function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('imagePreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}


function validarTexto(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 45) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Texto inválido ou quantidade de caracteres insuficiente (5 no minimo)"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoTextArea(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;
    
    inputNome.addEventListener('input', function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity("Texto inválido ou quantidade de caracteres insuficiente (5 no mínimo)");
        } else {
            inputNome.setCustomValidity("");
        }
        inputNome.reportValidity();
    });
}



const titulo = document.getElementById("titulo");
const descricao = document.getElementById("descricao");


validarTexto(titulo);
if (descricao) {
    validarTextoTextArea(descricao);
}



