
function validarTextoComAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}



const nomeCategoriaParceiro = document.getElementById("nome");

validarTextoComAcentos(nomeCategoriaParceiro);

