///////////////////////////////////// EXPRESSOES //////////////////////////////////

const validaTextoComCaracteresEspeciais =
  /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;

const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z]{2,}$/;
const validaNumeroDeTelefone =
  /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;

function formatarText(element) {
  let nomeSemEspaco = element.value.trim();
  if (nomeSemEspaco.length < 5) {
    element.setCustomValidity(" ");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}

function formatarData(dataNascimento) {
  // Criar um objeto Date com a data de nascimento
  return new Date(dataNascimento);
}

///////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////// VALIDACOES //////////////////////////////////

///////////////////////////// DADOS PESSOAIS /////////////////////////////////////////

const dataNascimento = document.getElementById("data-nascimento-input");
const nome = document.getElementById("nome-completo-input");
const email = document.getElementById("email-input");
const foto = document.getElementById("foto-input");

var fileFoto = null;

nome.onkeyup = function () {
  let nomeSemEspaco = nome.value.trim();
  if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
    nome.setCustomValidity("Informe um nome sem caracteres especiais(Excepto os acentos), números e com 4 letras no minimo!");
    nome.reportValidity();
  } else {
    nome.setCustomValidity("");
  }
};

email.onkeyup = function () {
  if (!validaEmail.test(email.value)) {
    email.setCustomValidity("E-mail inválido...");
    email.reportValidity();
  } else {
    email.setCustomValidity("");
  }
};

dataNascimento.onkeyup = function () {
  if (!verificarIdade(dataNascimento.value)) {
    dataNascimento.setCustomValidity("O Associado deve ter pelo menos 18 anos.");
    dataNascimento.reportValidity();
  } else {
    dataNascimento.setCustomValidity("");

  }
};

document.getElementById('data-nascimento-input').addEventListener('change', function () {
  if (!verificarIdade(dataNascimento.value)) {
    dataNascimento.setCustomValidity("O Associado deve ter pelo menos 18 anos.");
    dataNascimento.reportValidity();
  } else {
    dataNascimento.setCustomValidity("");
  }
});





