
///////////////////////////////////// EXPRESSOES //////////////////////////////////
const validaNumeroDoBIAngolano =
  /^[0-9]{9}(LA|BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LN|LS|ME|MO|NE|UE|ZE|OE|VP)[0-9]{3}$/;
const validaTextoComCaracteresEspeciais =
  /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;
const validaNumeroDaCedulaAngolana = /^\d{9,10}$/;
const validaNumeroDoPassaporteAngolano = /^[A-Z]{2}\d{7}$/;
const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z]{2,}$/;
const validaNumeroDeTelefone = /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;
const validaNumeroMecanograficoEDeAssociado =  /^[0-9][0-9]{0,8}$/

////////////////////////////////// Funcoes auxiliares //////////////////////////////////
function formatarIBAN(element) {
  
  let valor = element.value.replace(/[^0-9.]/g, '');
  
  const partes = valor.split('.').join('').match(/.{1,4}/g); 
  if (partes) {
    valor = partes.join('.'); 
  }
  
  element.value = valor;
}

function validarNumeroDeTelefone(element) {
  if (!validaNumeroDeTelefone.test(element.value)) {
    element.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}

function validarNumeros(element) {
  if (!validaNumeroMecanograficoEDeAssociado.test(element.value) || element.value.length < 1 || element.value.length < 5) {
    element.setCustomValidity("O número Mecanografico deve ter no minimo 5");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}

function formatarText(element) {
  let nomeSemEspaco = element.value.trim();
  if (nomeSemEspaco.length < 2) {
    element.setCustomValidity(" ");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}


function formatarSalario(element) {
  // Remove todos os caracteres que não sejam números
  let valor = element.value.replace(/\D/g, '');

  // Verifica se o valor é um número válido
  if (isNaN(valor) || valor === '') {
      element.setCustomValidity(" ");
      element.reportValidity();
  }

  // Adiciona as casas decimais
  valor = (valor / 100).toFixed(2) + '';


  element.setCustomValidity("");
  element.value = valor;
}

function formatarNumeroSegurancaSocial(input) {
  let valor = input.value.replace(/\D/g, "");

  if (valor.length > 3 && valor.length <= 6) {
      input.value = valor.slice(0, 3) + "-" + valor.slice(3);
  } else if (valor.length > 6) {
      input.value = valor.slice(0, 3) + "-" + valor.slice(3, 6) + "-" + valor.slice(6, 9);
  } else {
      input.value = valor;
  }
}

function verificarIdade(dataNascimento) {
  // Criar um objeto Date com a data de nascimento
  const dataNasc = new Date(dataNascimento);
  // Calcular a idade atual
  const hoje = new Date();
  const idade = hoje.getFullYear() - dataNasc.getFullYear();
  //     // Verificar se a pessoa tem mais de 18 anos e menos de 90 anos
  return idade >= 18 ? true : false;
}


///////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////// VALIDACOES //////////////////////////////////

///////////////////////////// DADOS PESSOAIS /////////////////////////////////////////

const dataNascimento = document.getElementById("data-nascimento-input");
const nome = document.getElementById("nome-completo-input");
const email = document.getElementById("email-input");

nome.onkeyup = function () {
  let nomeSemEspaco = nome.value.trim();
  if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 4) {
    nome.setCustomValidity("Informe um nome sem caracteres especiais(Excepto os acentos), números e com 4 letras no minimo!");
    nome.reportValidity();
  } else {
    nome.setCustomValidity("");
  }
};

email.onkeyup = function () {
  if (!validaEmail.test(email.value)) {
    email.setCustomValidity("E-mail inválido...");
    email.reportValidity();
  } else {
    email.setCustomValidity("");
  }
};

dataNascimento.onkeyup = function () {
  if (!verificarIdade(dataNascimento.value)) {
    dataNascimento.setCustomValidity("O Associado deve ter pelo menos 18 anos.");
    dataNascimento.reportValidity();
  } else {
    dataNascimento.setCustomValidity("");

  }
};

document.getElementById('data-nascimento-input').addEventListener('change', function () {
  if (!verificarIdade(dataNascimento.value)) {
    dataNascimento.setCustomValidity("O Associado deve ter pelo menos 18 anos.");
    dataNascimento.reportValidity();
  } else {
    dataNascimento.setCustomValidity("");
  }
});


///////////////////////// Validacao de ate 5 documentos //////////////////////////////////
///////////////////////// Documentos de Identificação - 1 //////////////////////////////////
const numero_documento1 = document.getElementById("numero-documento-input-1");
const data_emissao1 = document.getElementById("data-emissao-input-1");
const data_expiracao1 = document.getElementById("data-expiracao-input-1");
const dataExpiracaoContainer = document.getElementById('data-expiracao-container')
const checkVitalicioConteiner = document.getElementById('check-conteiner')
const checkVitalicioinput = document.getElementById('documento-vitalicio-checkbox')

//let validaNumeroDoDocumentoDeIdentificacao1 = ''

document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-documento-select-1') {
    let validaNumeroDoDocumentoDeIdentificacao1 = ''
    const valorSelecionado = event.target.value;

    const numero_documento1 = document.getElementById("numero-documento-input-1");
    console.log(valorSelecionado)
    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "2":
        // document.getElementById("data-expiracao-input-1").value = ''
        // document.getElementById("data-expiracao-input-1").disabled = false;
        // document.getElementById("data-expiracao-input-1").required = true;
        if(checkVitalicioinput.checked){
          checkVitalicioinput.checked = ''
          data_expiracao1.required = true;
        }else{
          data_expiracao1.required = true;
        }
        dataExpiracaoContainer.hidden = false;
        checkVitalicioConteiner.removeAttribute('hidden');
        validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDoBIAngolano;
        
        if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value.toUpperCase()) && numero_documento1.value) {
          numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo ");
          numero_documento1.reportValidity();
        } else {
          numero_documento1.setCustomValidity("");
        }
        break;
      case "1":
        // document.getElementById("data-expiracao-input-1").value = ''
        // document.getElementById("data-expiracao-input-1").required = false
        // document.getElementById("data-expiracao-input-1").disabled = true;
        dataExpiracaoContainer.hidden = true;
        data_expiracao1.required = false;
        checkVitalicioConteiner.setAttribute('hidden', true);
        validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDaCedulaAngolana;
        if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value) && numero_documento1.value) {
          numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo ");
          numero_documento1.reportValidity();
        } else {
          numero_documento1.setCustomValidity("");
        }
        break;
      case "3":
        // document.getElementById("data-expiracao-input-1").value = ''
        // document.getElementById("data-expiracao-input-1").disabled = false;
        // document.getElementById("data-expiracao-input-1").required = true;
        if(checkVitalicioinput.checked){
          checkVitalicioinput.checked = ''
          data_expiracao1.required = true;
        }else{
          data_expiracao1.required = true;
        }
        dataExpiracaoContainer.hidden = false;
        checkVitalicioConteiner.removeAttribute('hidden');
        validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDoPassaporteAngolano;
        
        if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value) && numero_documento1.value) {
          numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo ");
          numero_documento1.reportValidity();
        } else {
          numero_documento1.setCustomValidity("");
        }
        break;
      case "4":
        // document.getElementById("data-expiracao-input-1").value = ''
        // document.getElementById("data-expiracao-input-1").disabled = true;
        // document.getElementById("data-expiracao-input-1").required = false;
        if(checkVitalicioinput.checked){
          checkVitalicioinput.checked = ''
          data_expiracao1.required = true;
        }else{
          data_expiracao1.required = true;
        }
        dataExpiracaoContainer.hidden = false;
        checkVitalicioConteiner.removeAttribute('hidden');
        validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDoBIAngolano;
        
        if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value.toUpperCase()) && numero_documento1.value) {
          numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo ");
          numero_documento1.reportValidity();
        } else {
          numero_documento1.setCustomValidity("");
        }
        break;
      default:
        validaNumeroDoDocumentoDeIdentificacao1 = validaTextoComCaracteresEspeciais;
        console.log('Nenhum documento selecionado correspondente');
    }

    numero_documento1.onkeyup = function () {
      if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value.toUpperCase())) {
        numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo! ");
        numero_documento1.reportValidity();
      } else {
        numero_documento1.setCustomValidity("");
      }
    }
  }

  if (event.target.id === 'data-emissao-input-1' || event.target.id === 'data-expiracao-input-1') {
    document.getElementById('data-emissao-input-1').addEventListener('change', function() {
      const dataEmissao = new Date(this.value);

      if (isNaN(dataEmissao)) {
        return;
      }
      const dataExpiracaoInput = document.getElementById('data-expiracao-input-1');
      const dataExpiracaoMin = new Date(dataEmissao);
      dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);
      const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];


      dataExpiracaoInput.min = dataExpiracaoMinFormatada;
      dataExpiracaoInput.required ? dataExpiracaoInput.disabled = false : dataExpiracaoInput.value = "";
    });

    document.getElementById('data-expiracao-input-1').addEventListener('change', function() {
      const dataExpiracao = new Date(this.value);
      if (isNaN(dataExpiracao)) {
        return;
      }

      const dataActual = new Date();
      dataActual.setHours(0, 0, 0, 0);
      dataExpiracao.setHours(0, 0, 0, 0);
      if (dataExpiracao <= dataActual) {
        document.getElementById('data-expiracao-input-1').setCustomValidity("Data de expiração inválida ou Documento caducado");
        document.getElementById('data-expiracao-input-1').reportValidity();
        console.log("AAAAAAAAAAA");
      }else{
        document.getElementById('data-expiracao-input-1').setCustomValidity("");
      }

      // const dataExpiracaoMinFormatada = dataExpiracao.toISOString().split('T')[0];
      // console.log(dataExpiracaoMinFormatada);
    });
  }

});
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////// Documentos de Identificação - 2 //////////////////////////////////
// Escuta eventos de alteração no documento pai (neste caso, o body ou outro contêiner)
// document.body.addEventListener('change', function (event) {

//   if (event.target.id === 'tipo-documento-select-2') {
//     let validaNumeroDoDocumentoDeIdentificacao2 = ''
//     const valorSelecionado = event.target.value;


//     const numero_documento2 = document.getElementById("numero-documento-input-2");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "2":
//           document.getElementById("data-expiracao-input-2").value = ''
//           document.getElementById("data-expiracao-input-2").disabled = false;
//           document.getElementById("data-expiracao-input-2").required = true;
//         validaNumeroDoDocumentoDeIdentificacao2 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao2.test(numero_documento2.value.toUpperCase()) && numero_documento2.value) {
//           numero_documento2.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento2.reportValidity();
//         } else {
//           numero_documento2.setCustomValidity("");
//         }
//         break;
//       case "1":
//         document.getElementById("data-expiracao-input-2").value = ''
//           document.getElementById("data-expiracao-input-2").required = false
//           document.getElementById("data-expiracao-input-2").disabled = true;
//         validaNumeroDoDocumentoDeIdentificacao2 = validaNumeroDaCedulaAngolana;
//         if (!validaNumeroDoDocumentoDeIdentificacao2.test(numero_documento2.value) && numero_documento2.value) {
//           numero_documento2.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento2.reportValidity();
//         } else {
//           numero_documento2.setCustomValidity("");
//         }
//         break;
//       case "3":
//         document.getElementById("data-expiracao-input-2").value = ''
//           document.getElementById("data-expiracao-input-2").disabled = false;
//           document.getElementById("data-expiracao-input-2").required = true;
//         validaNumeroDoDocumentoDeIdentificacao2 = validaNumeroDoPassaporteAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao2.test(numero_documento2.value) && numero_documento2.value) {
//           numero_documento2.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento2.reportValidity();
//         } else {
//           numero_documento2.setCustomValidity("");
//         }
//         break;
//       case "4":
//         document.getElementById("data-expiracao-input-2").value = ''
//         document.getElementById("data-expiracao-input-2").disabled = true;
//         document.getElementById("data-expiracao-input-2").required = false;
//       validaNumeroDoDocumentoDeIdentificacao2 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao2.test(numero_documento2.value.toUpperCase()) && numero_documento2.value) {
//           numero_documento2.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento2.reportValidity();
//         } else {
//           numero_documento2.setCustomValidity("");
//         }
//         break;
//       default:
//         validaNumeroDoDocumentoDeIdentificacao2 = validaTextoComCaracteresEspeciais;
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     numero_documento2.onkeyup = function () {
//       if (!validaNumeroDoDocumentoDeIdentificacao2.test(numero_documento2.value.toUpperCase())) {
//         numero_documento2.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         numero_documento2.reportValidity();
//       } else {
//         numero_documento2.setCustomValidity("");
//       }
//     }
//   }

//   if (event.target.id === 'data-emissao-input-2' || event.target.id === 'data-expiracao-input-2') {
//     document.getElementById('data-emissao-input-2').addEventListener('change', function() {
//       const dataEmissao = new Date(this.value);

//       if (isNaN(dataEmissao)) {
//         return; // Se a data for inválida, não faz nada
//       }
//       const dataExpiracaoInput = document.getElementById('data-expiracao-input-2');
//       // Adicionar 5 anos à data de emissão
//       const dataExpiracaoMin = new Date(dataEmissao);
//       dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);
//       // Formatando a data no formato YYYY-MM-DD para o campo de input
//       const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];
//       // Definir o valor mínimo no campo de expiração
//       dataExpiracaoInput.min = dataExpiracaoMinFormatada;
//       dataExpiracaoInput.required ? dataExpiracaoInput.disabled = false: dataExpiracaoInput.value = "";
//     });

//     document.getElementById('data-expiracao-input-2').addEventListener('change', function() {
//       const dataExpiracao = new Date(this.value);
//       if (isNaN(dataExpiracao)) {
//         return;
//       }

//       const dataActual = new Date();
//       dataActual.setHours(0, 0, 0, 0);

//       if (dataExpiracao <= dataActual) {
//         document.getElementById('data-expiracao-input-2').setCustomValidity("Data de expiração inválida ou Documento caducado");
//         document.getElementById('data-expiracao-input-2').reportValidity();
//       }else{
//         document.getElementById('data-expiracao-input-2').setCustomValidity("");
//       }

//       // const dataExpiracaoMinFormatada = dataExpiracao.toISOString().split('T')[0];
//       // console.log(dataExpiracaoMinFormatada);
//     });
//   }

// });

// ///////////////////////////////////////////////////////////////////////////////////////////


// ///////////////////////// Documentos de Identificação - 3 //////////////////////////////////
// document.body.addEventListener('change', function (event) {

//   if (event.target.id === 'tipo-documento-select-3') {
//     let validaNumeroDoDocumentoDeIdentificacao3 = ''
//     const valorSelecionado = event.target.value;


//     const numero_documento3 = document.getElementById("numero-documento-input-3");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "2":
//         document.getElementById("data-expiracao-input-3").value = ''
//           document.getElementById("data-expiracao-input-3").disabled = false;
//           document.getElementById("data-expiracao-input-3").required = true;
//         validaNumeroDoDocumentoDeIdentificacao3 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao3.test(numero_documento3.value.toUpperCase()) && numero_documento3.value) {
//           numero_documento3.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento3.reportValidity();
//         } else {
//           numero_documento3.setCustomValidity("");
//         }
//         break;
//       case "1":
//           document.getElementById("data-expiracao-input-3").value = ''
//           document.getElementById("data-expiracao-input-3").required = false
//           document.getElementById("data-expiracao-input-3").disabled = true;
//           validaNumeroDoDocumentoDeIdentificacao3 = validaNumeroDaCedulaAngolana;
//         if (!validaNumeroDoDocumentoDeIdentificacao3.test(numero_documento3.value) && numero_documento3.value) {
//           numero_documento3.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento3.reportValidity();
//         } else {
//           numero_documento3.setCustomValidity("");
//         }
//         break;
//       case "3":
//         document.getElementById("data-expiracao-input-3").value = ''
//         document.getElementById("data-expiracao-input-3").disabled = false;
//         document.getElementById("data-expiracao-input-3").required = true;
//         validaNumeroDoDocumentoDeIdentificacao3 = validaNumeroDoPassaporteAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao3.test(numero_documento3.value) && numero_documento3.value) {
//           numero_documento3.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento3.reportValidity();
//         } else {
//           numero_documento3.setCustomValidity("");
//         }
//         break;
//       case "4":
//           document.getElementById("data-expiracao-input-3").value = ''
//           document.getElementById("data-expiracao-input-3").disabled = true;
//           document.getElementById("data-expiracao-input-3").required = false;
//           validaNumeroDoDocumentoDeIdentificacao3 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao3.test(numero_documento3.value.toUpperCase()) && numero_documento3.value) {
//           numero_documento3.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento3.reportValidity();
//         } else {
//           numero_documento3.setCustomValidity("");
//         }
//         break;
//       default:
//         validaNumeroDoDocumentoDeIdentificacao3 = validaTextoComCaracteresEspeciais;
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     numero_documento3.onkeyup = function () {
//       if (!validaNumeroDoDocumentoDeIdentificacao3.test(numero_documento3.value.toUpperCase())) {
//         numero_documento3.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         numero_documento3.reportValidity();
//       } else {
//         numero_documento3.setCustomValidity("");
//       }
//     }
//   }

//   // Verificar data de emissão e expiração
//   if (event.target.id === 'data-emissao-input-3' || event.target.id === 'data-expiracao-input-3') {
//     document.getElementById('data-emissao-input-3').addEventListener('change', function() {
//       const dataEmissao = new Date(this.value);

//       if (isNaN(dataEmissao)) {
//         return; // Se a data for inválida, não faz nada
//       }

//       const dataExpiracaoInput = document.getElementById('data-expiracao-input-3');

//       // Adicionar 5 anos à data de emissão
//       const dataExpiracaoMin = new Date(dataEmissao);
//       dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);

//       // Formatando a data no formato YYYY-MM-DD para o campo de input
//       const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];

//       // Definir o valor mínimo no campo de expiração
//       dataExpiracaoInput.min = dataExpiracaoMinFormatada;
//       dataExpiracaoInput.required ? dataExpiracaoInput.disabled = false : dataExpiracaoInput.value = "";
//     });

//     document.getElementById('data-expiracao-input-3').addEventListener('change', function() {
//       const dataExpiracao = new Date(this.value);
//       if (isNaN(dataExpiracao)) {
//         return;
//       }

//       const dataActual = new Date();
//       dataActual.setHours(0, 0, 0, 0);

//       if (dataExpiracao <= dataActual) {
//         document.getElementById('data-expiracao-input-3').setCustomValidity("Data de expiração inválida ou Documento caducado");
//         document.getElementById('data-expiracao-input-3').reportValidity();
//       }else{
//         document.getElementById('data-expiracao-input-3').setCustomValidity("");
//       }

//       // const dataExpiracaoMinFormatada = dataExpiracao.toISOString().split('T')[0];
//       // console.log(dataExpiracaoMinFormatada);
//     });
//   }
// });
// ///////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////// Documentos de Identificação - 4 //////////////////////////////////
// document.body.addEventListener('change', function (event) {

//   if (event.target.id === 'tipo-documento-select-4') {
//     let validaNumeroDoDocumentoDeIdentificacao4 = ''
//     const valorSelecionado = event.target.value;


//     const numero_documento4 = document.getElementById("numero-documento-input-4");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "2":
//         document.getElementById("data-expiracao-input-4").value = ''
//         document.getElementById("data-expiracao-input-4").disabled = false;
//         document.getElementById("data-expiracao-input-4").required = true;
//         validaNumeroDoDocumentoDeIdentificacao4 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao4.test(numero_documento4.value.toUpperCase()) && numero_documento4.value) {
//           numero_documento4.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento4.reportValidity();
//         } else {
//           numero_documento4.setCustomValidity("");
//         }
//         break;
//       case "1":
//         document.getElementById("data-expiracao-input-4").value = ''
//         document.getElementById("data-expiracao-input-4").required = false
//         document.getElementById("data-expiracao-input-4").disabled = true;
//         validaNumeroDoDocumentoDeIdentificacao4 = validaNumeroDaCedulaAngolana;
//         if (!validaNumeroDoDocumentoDeIdentificacao4.test(numero_documento4.value) && numero_documento4.value) {
//           numero_documento4.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento4.reportValidity();
//         } else {
//           numero_documento4.setCustomValidity("");
//         }
//         break;
//       case "3":
//           document.getElementById("data-expiracao-input-4").value = ''
//           document.getElementById("data-expiracao-input-4").disabled = false;
//           document.getElementById("data-expiracao-input-4").required = true;
//         validaNumeroDoDocumentoDeIdentificacao4 = validaNumeroDoPassaporteAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao4.test(numero_documento4.value) && numero_documento4.value) {
//           numero_documento4.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento4.reportValidity();
//         } else {
//           numero_documento4.setCustomValidity("");
//         }
//         break;
//       case "4":
//           document.getElementById("data-expiracao-input-4").value = ''
//           document.getElementById("data-expiracao-input-4").disabled = true;
//           document.getElementById("data-expiracao-input-4").required = false;
//         validaNumeroDoDocumentoDeIdentificacao4 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao4.test(numero_documento4.value.toUpperCase()) && numero_documento4.value) {
//           numero_documento4.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento4.reportValidity();
//         } else {
//           numero_documento4.setCustomValidity("");
//         }
//         break;
//       default:
//         validaNumeroDoDocumentoDeIdentificacao4 = validaTextoComCaracteresEspeciais;
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     numero_documento4.onkeyup = function () {
//       if (!validaNumeroDoDocumentoDeIdentificacao4.test(numero_documento4.value.toUpperCase())) {
//         numero_documento4.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         numero_documento4.reportValidity();
//       } else {
//         numero_documento4.setCustomValidity("");
//       }
//     }
//   }

//   // Verificar data de emissão e expiração
//   if (event.target.id === 'data-emissao-input-4' || event.target.id === 'data-expiracao-input-4') {
//     document.getElementById('data-emissao-input-4').addEventListener('change', function() {
//       const dataEmissao = new Date(this.value);

//       if (isNaN(dataEmissao)) {
//         return; // Se a data for inválida, não faz nada
//       }

//       const dataExpiracaoInput = document.getElementById('data-expiracao-input-4');

//       // Adicionar 5 anos à data de emissão
//       const dataExpiracaoMin = new Date(dataEmissao);
//       dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);

//       // Formatando a data no formato YYYY-MM-DD para o campo de input
//       const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];

//       // Definir o valor mínimo no campo de expiração
//       dataExpiracaoInput.min = dataExpiracaoMinFormatada;
//       dataExpiracaoInput.required ? dataExpiracaoInput.disabled = false : dataExpiracaoInput.value = "";
//     });

//     document.getElementById('data-expiracao-input-4').addEventListener('change', function() {
//       const dataExpiracao = new Date(this.value);
//       if (isNaN(dataExpiracao)) {
//         return;
//       }

//       const dataActual = new Date();
//       dataActual.setHours(0, 0, 0, 0);

//       if (dataExpiracao <= dataActual) {
//         document.getElementById('data-expiracao-input-4').setCustomValidity("Data de expiração inválida ou Documento caducado");
//         document.getElementById('data-expiracao-input-4').reportValidity();
//       }else{
//         document.getElementById('data-expiracao-input-4').setCustomValidity("");
//       }

//       // const dataExpiracaoMinFormatada = dataExpiracao.toISOString().split('T')[0];
//       // console.log(dataExpiracaoMinFormatada);
//     });
//   }
// });
// ///////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {

//   if (event.target.id === 'tipo-documento-select-5') {
//     let validaNumeroDoDocumentoDeIdentificacao5 = ''
//     const valorSelecionado = event.target.value;


//     const numero_documento5 = document.getElementById("numero-documento-input-5");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "2":
//           document.getElementById("data-expiracao-input-5").value = ''
//           document.getElementById("data-expiracao-input-5").disabled = false;
//           document.getElementById("data-expiracao-input-5").required = true;
//           validaNumeroDoDocumentoDeIdentificacao5 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao5.test(numero_documento5.value.toUpperCase()) && numero_documento5.value) {
//           numero_documento5.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento5.reportValidity();
//         } else {
//           numero_documento5.setCustomValidity("");
//         }
//         break;
//       case "1":
//         document.getElementById("data-expiracao-input-5").value = ''
//         document.getElementById("data-expiracao-input-5").required = false
//         document.getElementById("data-expiracao-input-5").disabled = true;
//         validaNumeroDoDocumentoDeIdentificacao5 = validaNumeroDaCedulaAngolana;
//         if (!validaNumeroDoDocumentoDeIdentificacao5.test(numero_documento5.value) && numero_documento5.value) {
//           numero_documento5.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento5.reportValidity();
//         } else {
//           numero_documento5.setCustomValidity("");
//         }
//         break;
//       case "3":
//           document.getElementById("data-expiracao-input-5").value = ''
//           document.getElementById("data-expiracao-input-5").disabled = false;
//           document.getElementById("data-expiracao-input-5").required = true;
//         validaNumeroDoDocumentoDeIdentificacao5 = validaNumeroDoPassaporteAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao5.test(numero_documento5.value) && numero_documento5.value) {
//           numero_documento5.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento5.reportValidity();
//         } else {
//           numero_documento5.setCustomValidity("");
//         }
//         break;
//       case "4":
//           document.getElementById("data-expiracao-input-5").value = ''
//           document.getElementById("data-expiracao-input-5").disabled = true;
//           document.getElementById("data-expiracao-input-5").required = false;
//           validaNumeroDoDocumentoDeIdentificacao5 = validaNumeroDoBIAngolano;
//         if (!validaNumeroDoDocumentoDeIdentificacao5.test(numero_documento5.value.toUpperCase()) && numero_documento5.value) {
//           numero_documento5.setCustomValidity("O número do documento não corresponde ao tipo ");
//           numero_documento5.reportValidity();
//         } else {
//           numero_documento5.setCustomValidity("");
//         }
//         break;
//       default:
//         validaNumeroDoDocumentoDeIdentificacao5 = validaTextoComCaracteresEspeciais;
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     numero_documento5.onkeyup = function () {
//       if (!validaNumeroDoDocumentoDeIdentificacao5.test(numero_documento5.value.toUpperCase())) {
//         numero_documento5.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         numero_documento5.reportValidity();
//       } else {
//         numero_documento5.setCustomValidity("");
//       }
//     }
//   }

//   // Verificar data de emissão e expiração
//   if (event.target.id === 'data-emissao-input-5' || event.target.id === 'data-expiracao-input-5') {
//     document.getElementById('data-emissao-input-5').addEventListener('change', function() {
//       const dataEmissao = new Date(this.value);

//       if (isNaN(dataEmissao)) {
//         return; // Se a data for inválida, não faz nada
//       }

//       const dataExpiracaoInput = document.getElementById('data-expiracao-input-5');

//       // Adicionar 5 anos à data de emissão
//       const dataExpiracaoMin = new Date(dataEmissao);
//       dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);

//       // Formatando a data no formato YYYY-MM-DD para o campo de input
//       const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];

//       // Definir o valor mínimo no campo de expiração
//       dataExpiracaoInput.min = dataExpiracaoMinFormatada;
//       dataExpiracaoInput.required ? dataExpiracaoInput.disabled = false: dataExpiracaoInput.value = "";
//     });

//     document.getElementById('data-expiracao-input-5').addEventListener('change', function() {
//       const dataExpiracao = new Date(this.value);
//       if (isNaN(dataExpiracao)) {
//         return;
//       }

//       const dataActual = new Date();
//       dataActual.setHours(0, 0, 0, 0);

//       if (dataExpiracao <= dataActual) {
//         document.getElementById('data-expiracao-input-5').setCustomValidity("Data de expiração inválida ou Documento caducado");
//         document.getElementById('data-expiracao-input-5').reportValidity();
//       }else{
//         document.getElementById('data-expiracao-input-5').setCustomValidity("");
//       }

//       // const dataExpiracaoMinFormatada = dataExpiracao.toISOString().split('T')[0];
//       // console.log(dataExpiracaoMinFormatada);
//     });
//   }
// });
///////////////////////////////////////////////////////////////////////////////////////////


///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {
//   if (event.target.id === 'tipo-contacto-select-2') {
//     let validaContacto2 = ''
//     const valorSelecionado = event.target.value;
//     console.log(valorSelecionado)
//     const contacto2 = document.getElementById("contacto-input-2");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "1":
//         validaContacto2 = validaNumeroDeTelefone
//         if (!validaContacto2.test(contacto2.value) && contacto2.value) {
//           contacto2.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto2.reportValidity();
//           } else {
//             contacto2.setCustomValidity("");
//           }
//         break;
//       case "2":
//         validaContacto2 = validaEmail
//         if (!validaContacto2.test(contacto2.value) && contacto2.value) {
//           contacto2.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
//           contacto2.reportValidity();
//           } else {
//             contacto2.setCustomValidity("");
//           }
//         break;
//       case "3":
//         validaContacto2 = validaNumeroDeTelefone
//         if (!validaContacto2.test(contacto2.value) && contacto2.value) {
//           contacto2.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto2.reportValidity();
//           } else {
//             contacto2.setCustomValidity("");
//           }
//         break;
//       default:
//         validaContacto2 = validaTextoComCaracteresEspeciais
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     contacto2.onkeyup = function () {
//       if (!validaContacto2.test(contacto2.value)) {
//         contacto2.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         contacto2.reportValidity();
//       } else {
//         contacto2.setCustomValidity("");
//       }
//     }
//   }

// });
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {
//   if (event.target.id === 'tipo-contacto-select-3') {
//     let validaContacto3 = ''
//     const valorSelecionado = event.target.value;


//     const contacto3 = document.getElementById("contacto-input-3");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "1":
//         validaContacto3 = validaNumeroDeTelefone
//         if (!validaContacto3.test(contacto3.value) && contacto3.value) {
//           contacto3.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto3.reportValidity();
//           } else {
//             contacto3.setCustomValidity("");
//           }
//         break;
//       case "2":
//         validaContacto3 = validaEmail
//         if (!validaContacto3.test(contacto3.value) && contacto3.value) {
//           contacto3.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
//           contacto3.reportValidity();
//           } else {
//             contacto3.setCustomValidity("");
//           }
//         break;
//       case "3":
//         validaContacto3 = validaNumeroDeTelefone
//         if (!validaContacto3.test(contacto3.value) && contacto3.value) {
//           contacto3.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto3.reportValidity();
//           } else {
//             contacto3.setCustomValidity("");
//           }
//         break;
//       default:
//         validaContacto3 = validaTextoComCaracteresEspeciais
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     contacto3.onkeyup = function () {
//       if (!validaContacto3.test(contacto3.value)) {
//         contacto3.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         contacto3.reportValidity();
//       } else {
//         contacto3.setCustomValidity("");
//       }
//     }
//   }

// });
// ///////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {
//   if (event.target.id === 'tipo-contacto-select-4') {
//     let validaContacto4 = ''
//     const valorSelecionado = event.target.value;


//     const contacto4 = document.getElementById("contacto-input-4");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "1":
//         validaContacto4 = validaNumeroDeTelefone
//         if (!validaContacto4.test(contacto4.value) && contacto4.value) {
//           contacto4.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto4.reportValidity();
//           } else {
//             contacto4.setCustomValidity("");
//           }
//         break;
//       case "2":
//         validaContacto4 = validaEmail
//         if (!validaContacto4.test(contacto4.value) && contacto4.value) {
//           contacto4.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
//           contacto4.reportValidity();
//           } else {
//             contacto4.setCustomValidity("");
//           }
//         break;
//       case "3":
//         validaContacto4 = validaNumeroDeTelefone
//         if (!validaContacto4.test(contacto4.value) && contacto4.value) {
//           contacto4.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto4.reportValidity();
//           } else {
//             contacto4.setCustomValidity("");
//           }
//         break;
//       default:
//         validaContacto4 = validaTextoComCaracteresEspeciais
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     contacto4.onkeyup = function () {
//       if (!validaContacto4.test(contacto4.value)) {
//         contacto4.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         contacto4.reportValidity();
//       } else {
//         contacto4.setCustomValidity("");
//       }
//     }
//   }

// });
// ///////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {
//   if (event.target.id === 'tipo-contacto-select-5') {
//     let validaContacto5 = ''
//     const valorSelecionado = event.target.value;


//     const contacto5 = document.getElementById("contacto-input-5");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "1":
//         validaContacto5 = validaNumeroDeTelefone
//         if (!validaContacto5.test(contacto5.value) && contacto5.value) {
//           contacto5.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto5.reportValidity();
//           } else {
//             contacto5.setCustomValidity("");
//           }
//         break;
//       case "2":
//         validaContacto5 = validaEmail
//         if (!validaContacto5.test(contacto5.value) && contacto5.value) {
//           contacto5.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
//           contacto5.reportValidity();
//           } else {
//             contacto5.setCustomValidity("");
//           }
//         break;
//       case "3":
//         validaContacto5 = validaNumeroDeTelefone
//         if (!validaContacto5.test(contacto5.value) && contacto5.value) {
//           contacto5.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto5.reportValidity();
//           } else {
//             contacto5.setCustomValidity("");
//           }
//         break;
//       default:
//         validaContacto5 = validaTextoComCaracteresEspeciais
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     contacto5.onkeyup = function () {
//       if (!validaContacto5.test(contacto5.value)) {
//         contacto5.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         contacto5.reportValidity();
//       } else {
//         contacto5.setCustomValidity("");
//       }
//     }
//   }

// });
// ///////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
// document.body.addEventListener('change', function (event) {
//   if (event.target.id === 'tipo-contacto-select-6') {
//     let validaContacto6 = ''
//     const valorSelecionado = event.target.value;


//     const contacto6 = document.getElementById("contacto-input-6");

//     // Verifica o valor usando switch
//     switch (valorSelecionado) {
//       case "1":
//         validaContacto6 = validaNumeroDeTelefone
//         if (!validaContacto6.test(contacto6.value) && contacto6.value) {
//           contacto6.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto6.reportValidity();
//           } else {
//             contacto6.setCustomValidity("");
//           }
//         break;
//       case "2":
//         validaContacto6 = validaEmail
//         if (!validaContacto6.test(contacto6.value) && contacto6.value) {
//           contacto6.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
//           contacto6.reportValidity();
//           } else {
//             contacto6.setCustomValidity("");
//           }
//         break;
//       case "3":
//         validaContacto6 = validaNumeroDeTelefone
//         if (!validaContacto6.test(contacto6.value) && contacto6.value) {
//           contacto6.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
//           contacto6.reportValidity();
//           } else {
//             contacto6.setCustomValidity("");
//           }
//         break;
//       default:
//         validaContacto6 = validaTextoComCaracteresEspeciais
//         console.log('Nenhum documento selecionado correspondente');
//     }

//     contacto6.onkeyup = function () {
//       if (!validaContacto6.test(contacto6.value)) {
//         contacto6.setCustomValidity("O número do documento não corresponde ao tipo! ");
//         contacto6.reportValidity();
//       } else {
//         contacto6.setCustomValidity("");
//       }
//     }
//   }

// });
///////////////////////////////////////////////////////////////////////////////////////////
