<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('configuracoes_gerais', function (Blueprint $table) {
            $table->id();

            // Identidade
            $table->string('portal_nome')->nullable();
            $table->string('olimpo_app_nome')->nullable();

            // Cores
            $table->string('primary_color', 20)->default('#0d6efd');
            $table->string('secondary_color', 20)->default('#6c757d');

            // Ícone / favicon
            $table->string('shortcut_icon')->nullable();           // caminho relativo em /public

            // JSONs para conteúdo dinâmico
            $table->text('menu_items')->nullable();                // [{title,route,icon,visible}, ...]
            $table->text('redes_links')->nullable();              // [{platform,url,visible}, ...]
            $table->boolean('mostrar_redes_links')->default(true);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('configuracoes_gerais');
    }
};
