<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('p_r__mensagems', function (Blueprint $table) {
            $table->id();
            $table->longText('mensagem');
            $table->string('lema')->nullable();
            $table->foreignId('membro_id')->constrained('membro_comissaos')->onDelete('cascade');
            $table->integer('estado')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('p_r__mensagems');
    }
};
