<?php

namespace App\Services;

use App\Models\EmailLog;
use App\Data\EmailLogData;
use Exception;
use Illuminate\Support\Facades\DB;

class EmailLogs
{
    public static function log(EmailLogData $data)
    {
        //dd($data);
        try{
            DB::beginTransaction();
            $email = new EmailLog();
            $email->email_emissor = $data->email_emissor;
            $email->email_receptor = $data->email_receptor;
            $email->assunto = $data->assunto;
            $email->body = $data->body;
            $email->mail_class = $data->mail_class;
            $email->mensagem_erro = $data->mensagem_erro;
            $email->estado = $data->estado;
            $email->data_tentativa = $data->data_tentativa;
            $email->tentativas = $data->tentativas;
            $email->prioridade = $data->prioridade;
            $email->save();
            DB::commit();

        }catch(Exception $e){
            DB::rollBack();
            // throw new Exception("Erro ao gravar log do email: {$e->getMessage()}");
        }
    }
}
