<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\DB;


class User extends Authenticable
{
    use HasApiTokens, HasFactory, Notifiable;

    public function role()
    {
        return $this->hasOne(Role::class, 'id', 'role_id');
    }

    public function getRedirectRoute()
    {
        if (Auth::user()->role_id == 1) {            
            return 'homeAdmin';
        } elseif (Auth::user()->role_id == 2) {
            return 'homeGestor';
        }elseif (Auth::user()->role_id == 3) {
            return 'homeEditor';
        }
    }

    public static function getUser ($codigo, $email) {
		return DB::Select("SELECT * FROM users WHERE codigoReset = $codigo AND email = ?", [$email]);
	}

    public static function getUserByEmail ($codigo, $email) {
		return DB::Select("SELECT * FROM users WHERE codigoReset = $codigo AND email = ?", [$email]);
	}

    public static function getUserByTelefone ($codigo, $telefone) {
		return DB::Select("SELECT * FROM users WHERE codigoReset = $codigo AND telefone = ?", [$telefone]);
	}

    protected static function booted(){

        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo de um Utilizador');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo de um novo Utilizador');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete de um Utilizador');
		});
    }
}
