<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sms extends Model
{
    use HasFactory;

    public static function gerarMensagemRedefinicaoSenhaSMS(array $data): string
    {
        $dataAlteracao = $data['dataAlteracao'] ?? 'data desconhecida';

        return <<<SMS
        Porto FSTPL - Palavra-Passe alterada

        Olá, {$data['nomeUser']}. Sua palavra-passe foi alterada com sucesso em {$dataAlteracao}.
        SMS;
    }

    public static function gerarMensagemAdesaoEmAnaliseSMS(array $data): string
    {
        return <<<SMS
        FSTPL - Adesão em análise

        Caro(a) {$data['nomeCandidato']}, o seu pedido de adesão ao {$data['nomeEntidade']} voltou ao estado de análise.
        Será notificado(a) do resultado.
        Agradecemos pela sua paciência.

        Equipa FSTPL
        SMS;
    }

    public static function gerarMensagemCodigoRedefinicaoSMS(array $data): string
    {
        return <<<SMS
        Portal FSTPL - Redefinir Palavra-passe

        Olá {$data['nome']}, recebemos um pedido para redefinir sua palavra-passe.
        Código: {$data['codigo']}
        SMS;
    }

    public static function gerarMensagemNovoUser(array $data): string
    {
        return <<<SMS
        Portal FSTPL - Novo Utilizador

        Olá {$data['nome']}, Seja bem vindo.
        Nome de Utilizador: {$data['username']}
        Palavra-Passe: 87654321
        Faça login, e altere a sua palavra passe, não mostre esta sms para mais ninguém por motivos de segurança.
        SMS;
    }

    public static function gerarMensagemNovoCandidato(array $data): string
    {
        return <<<SMS
        Portal FSTPL - Pedido de Adesão

        Caro(a) {$data['nome']}! O seu pedido de adesão ao {$data['nomeEntidade']} encontra-se em análise.
        Será notificado pela mesma via, após validação e conclusão do processo.
        SMS;
    }

    public static function gerarMensagemReenvioCodigoConfirmacaoSMS(array $data): string
    {
        return <<<SMS
        Portal FSTPL - Reenvio de Código

        Olá {$data['nome']}, seu novo código de confirmação para redefinir a palavra-passe:

        Código: {$data['codigo']}
        Expira em: {$data['expiracao']}

        Equipa FSTPL
        SMS;
    }
}
