<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class NotificacaoConfig extends Model
{
    use HasFactory;

    protected $table = 'alarme_config';

    protected $fillable = [
        'tipo',
        'descricao',
    ];

    public static function current(): self
    {
        return static::query()->first() ?? static::query()->create();
    }

    protected static function booted(){
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização das configurações de Alerme(Notificações)');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo das configurações de Alerme(Notificações)');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete das configurações de Alerme(Notificações)');
		});
    }
}
