<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\General\AuditoriaGeneral;
use Illuminate\Support\Facades\Auth;

class Noticia extends Model
{
    use HasFactory;

    protected $fillable = [
        'titulo',
        'data_publicacao',
        'resumo',
        'foto',
        'corpo_noticia',
        'destaque',
        'estado',
    ];

    public function midias()
    {
        return $this->hasMany(MidiaNoticia::class);
    }

    protected static function booted(){

        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo de uma Notícia');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo de uma nova Notícia');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete de uma Notícia');
		});
    }
}
