<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class ContactoForm extends Controller
{
    private $nome;
    private $email;
    private $mensagem;
    private $contacto;


    public function __construct(Request $request){

        $this->nome = $request->nome;
        $this->email = $request->email;
        $this->contacto = $request->contacto;
        $this->mensagem = $request->mensagem;

    }

    public function sendMail(){

        $data = array(
            'nome' => $this->nome,
            'email' => $this->email,
            'contacto' => $this->contacto,
            'mensagem' => $this->mensagem
       );

       Mail::mailer('contact')->to(config('mail.from.contact_address'))
            ->send( new SendMail($data) );


    }
}
