<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\General\AuditoriaGeneral;
use Illuminate\Support\Facades\Auth;

class CategoriaParceiro extends Model
{
    use HasFactory;

    public function parceiros() {
        return $this->hasMany(Parceiro::class, 'categoria_id'); 
    }

    protected static function booted(){
        
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo de uma Categoria de Parceiro');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo de uma nova Categoria de Parceiro');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete de uma Categoria de Parceiro');
		});
    }
}
