<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Bunner extends Model
{
    use HasFactory;

    protected $table = 'cabecalhos';

    protected $fillable = [
        'titulo',
        'imagem',
        'cor_titulo',
        'isFixo',
        'estado',
    ];

    protected static function booted(){
        
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo de um item no bunner');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo de um novo item no bunner');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete de um item no bunner');
		});
    }
}
