<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class AppConfig extends Model
{
    use HasFactory;

    protected $table = 'configuracoes_gerais';

    protected $fillable = [
        'portal_nome',
        'olimpo_app_nome',
        'primary_color',
        'secondary_color',
        'shortcut_icon',
        'meta_dados',
        'menu_items',
        'redes_links',
        'mostrar_redes_links',
        'copyright'
    ];

    protected $casts = [
        'meta_dados'        => 'array',   
        'menu_items'        => 'array',   
        'redes_links'      => 'array',
        'mostrar_redes_links' => 'boolean',
    ];

    /**
     * Retorna sempre a primeira (e única) configuração.
     * Cria uma com valores padrão se ainda não existir.
     */
    public static function current(): self
    {
        return static::query()->first() ?? static::query()->create();
    }

    protected static function booted(){
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização das configurações globais do Sistema');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo das configurações globais do Sistema');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete das configurações globais do Sistema');
		});
    }
}
