<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateEntidadeSysRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //
            'nome'   => 'nullable|string|max:200',
            'local'  => 'required|numeric|max:11',
            'estado' => 'required|in:0,1',
            'logo' => 'image|mimes:png,jpg,jpeg', 
        ];
    }

    public function messages()
    {
        return [
            'nome.string' => 'O nome deve ser um texto.',
            'nome.max' => 'O nome não pode ter mais que 200 caracteres.',

            'local.required' => 'O campo local é obrigatório.',
            'local.numeric' => 'O campo local deve ser um número.',
            'local.max' => 'O campo local não pode ter mais que 11 dígitos.',

            'estado.required' => 'O campo estado é obrigatório.',
            'estado.in' => 'O campo estado deve ser (inativo) ou (ativo).',

            'logo.image' => 'O logo deve ser uma imagem.',
            'logo.mimes' => 'O logo deve estar no formato PNG ou JPG.',
        ];
    }
}
