<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:60',
            'username' => 'required|string|max:50|unique:users,username',
            'email' => 'required|email|unique:users,email',
            'telefone' => 'required|string|max:15|unique:users,telefone',
            'perfil' => 'required|exists:roles,id',
            'estado' => 'required',
            'foto' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ];
    }

    /**
     * Mensagens de erro personalizadas.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'nome.required' => 'O campo "Nome Completo" é obrigatório.',
            'nome.string' => 'O campo "Nome Completo" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome Completo" não pode ter mais de 60 caracteres.',

            'username.required' => 'O campo "Nome de Utilizador" é obrigatório.',
            'username.string' => 'O campo "Nome de Utilizador" deve ser um texto válido.',
            'username.max' => 'O campo "Nome de Utilizador" não pode ter mais de 50 caracteres.',
            'username.unique' => 'O "Nome de Utilizador" já está a ser utilizado.',

            'email.required' => 'O campo "E-mail" é obrigatório.',
            'email.email' => 'Por favor, insira um e-mail válido.',
            'email.unique' => 'Este e-mail já está a ser utilizado.',

            'telefone.required' => 'O campo "Telefone" é obrigatório.',
            'telefone.string' => 'O campo "Telefone" deve ser um texto válido.',
            'telefone.max' => 'O campo "Telefone" não pode ter mais de 15 caracteres.',
            'telefone.unique' => 'Este Número de telefone já está a ser utilizado.',

            'perfil.required' => 'O campo "Perfil" é obrigatório.',
            'perfil.exists' => 'O perfil selecionado não é válido.',
            
            'estado.required' => 'O campo "Estado" é obrigatório.',

            'foto.image' => 'O arquivo deve ser uma imagem.',
            'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png, jpg ou gif.',
            'foto.max' => 'A imagem não pode ter mais de 2MB.',
            'foto.required' => 'A imagem é obrigatória.',
        ];
    }


}