<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreMissaoVisaoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'categoria' => 'required',
            'descricao' => 'required|string|max:300',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'categoria.required' => 'O campo "Nome" é obrigatório.',

            'descricao.required' => 'O campo "Descrição" é obrigatório.',
            'descricao.string' => 'O campo "Descrição" deve ser um texto válido.',
            'descricao.max' => 'O campo "Descrição" não pode ter mais de 300 caracteres.',

            'estado.required' => 'O estado é obrigatório.',
        ];
    }
}
