<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreMensagemPcaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:250',
            'lema' => 'required|string|max:200',
            'mensagem' => 'required|string',
            // 'mensagem' => 'required|string|max:1500',
            'estado' => 'required',
            'foto' => 'required|image|mimes:jpeg,png,jpg|max:2048',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo "PCA" é obrigatório.',
            'nome.string' => 'O campo "PCA" deve ser um texto válido.',
            'nome.max' => 'O campo "PCA" não pode ter mais de 250 caracteres.',

            'lema.required' => 'O campo "Lema" é obrigatório.',
            'lema.string' => 'O campo "Lema" deve ser um texto válido.',
            'lema.max' => 'O campo "Lema" não pode ter mais de 200 caracteres.',

            'foto.image' => 'O arquivo enviado deve ser uma imagem.',
            'foto.required' => 'A imagem é obrigatória.',
            'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'foto.max' => 'A imagem não pode ter mais de 2MB.',

            'mensagem.required' => 'O corpo da "Mensagem" é obrigatório.',
            'estado.required' => 'O estado da notícia é obrigatório.',
        ];
    }
}
