<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreMembroComissaoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:200',
            'biografia' => 'required|string|max:2000',
            'foto' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo "Nome Completo" é obrigatório.',
            'nome.string' => 'O campo "Nome Completo" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome Completo" não pode ter mais de 200 caracteres.',

            'biografia.required' => 'O campo "Biografia" é obrigatório.',
            'biografia.string' => 'O campo "Biografia" deve ser um texto válido.',
            'biografia.max' => 'O campo "Biografia" não pode ter mais de 2000 caracteres.',

            'foto.image' => 'O arquivo enviado deve ser uma imagem.',
            'foto.required' => 'A imagem é obrigatória.',
            'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'foto.max' => 'A imagem não pode ter mais de 2MB.',

            'estado.required' => 'O estado é obrigatório.',
        ];
    }
}
