<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreEventosRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'titulo' => 'required|string|max:200',
            'data_evento' => 'required|date',
            'resumo' => 'required|string|max:300',
            'imagem' => 'required|image|mimes:jpeg,png,jpg|max:2048',
            // 'corpo_noticia' => 'required|string|max:1500',
            'detalhes' => 'required|string',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'titulo.required' => 'O campo "Título" é obrigatório.',
            'titulo.string' => 'O campo "Título" deve ser um texto válido.',
            'titulo.max' => 'O campo "Título" não pode ter mais de 200 caracteres.',


            'data_evento.required' => 'A data do Evento é obrigatória.',
            'data_evento.date' => 'A data do Evento deve ser uma data válida.',

            'resumo.required' => 'O campo "Resumo" é obrigatório.',
            'resumo.string' => 'O campo "Resumo" deve ser um texto válido.',
            'resumo.max' => 'O campo "Resumo" não pode ter mais de 300 caracteres.',

            'imagem.image' => 'O arquivo enviado deve ser uma imagem.',
            'imagem.required' => 'A imagem é obrigatória.',
            'imagem.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'imagem.max' => 'A imagem não pode ter mais de 2MB.',

            'detalhes.required' => 'O detalhe do evento é obrigatório.',
            'detalhes.string' => 'O detalhe do evento deve ser um texto válido.',
            // 'corpo_noticia.max' => 'O corpo da notícia não pode ter mais de 1500 caracteres.',

            'estado.required' => 'O estado da notícia é obrigatório.',
        ];
    }
}
