<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreDadosContactosRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'emailGeral' => 'required|email|unique:contacto_admins,emailGeral',
            'emailSuporte' => 'required|email|unique:contacto_admins,emailSuporte',
            'endereco' => 'required|string|max:200',
            'telefone' => 'string|max:15|unique:contacto_admins,telefone',
            'estado' => 'required',
            'latitude' => 'required|max:25',
            'longitude' => 'required|max:25',

        ];
    }

    public function messages(): array
    {
        return [
            'emailGeral.required' => 'O campo "Email Geral" é obrigatório.',
            'emailGeral.email' => 'O "Email Geral" deve ser um endereço de email válido.',
            'emailGeral.unique' => 'Este "Email Geral" já está a ser utilizado.',
            
            'emailSuporte.required' => 'O campo "Email de Suporte" é obrigatório.',
            'emailSuporte.email' => 'O "Email de Suporte" deve ser um endereço de email válido.',
            'emailSuporte.unique' => 'Este "Email de Suporte" já está a ser utilizado.',
            
            'endereco.required' => 'O campo "Endereço" é obrigatório.',
            'endereco.string' => 'O "Endereço" deve ser um texto.',
            'endereco.max' => 'O "Endereço" não pode exceder 200 caracteres.',
            
            'telefone.string' => 'O "Telefone" deve ser um texto.',
            'telefone.max' => 'O "Telefone" não pode exceder 15 caracteres.',
            'telefone.unique' => 'Este "Telefone" já está a ser utilizado..',
            
            'estado.required' => 'O campo "Estado" é obrigatório.',
            
            'latitude.max' => 'A "Latitude" não pode exceder 25 caracteres.',
            'latitude.required' => 'O campo "Latitude" é obrigatório.',
            
            'longitude.max' => 'A "Longitude" não pode exceder 25 caracteres.',
            'longitude.required' => 'O campo "Longitude" é obrigatório.',
        ];
    }
}
