<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreCargoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:200',
            'descricao' => 'nullable|string|max:200',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo "Nome" é obrigatório.',
            'nome.string' => 'O campo "Nome" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome" não pode ter mais de 200 caracteres.',

            'descricao.string' => 'O campo "Descrição" deve ser um texto válido.',
            'descricao.max' => 'O campo "Descrição" não pode ter mais de 200 caracteres.',
            
            'estado.required' => 'O estado do Benefício é obrigatório.',            
        ];
    }
}
