<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreAppConfigRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //
            'portal_nome'      => 'nullable|string|max:200',
            'olimpo_app_nome'   => 'nullable|string|max:200',
            'primary_color'    => 'required|string',
            'secondary_color'  => 'required|string',
            'shortcut_icon'    => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'mostrar_redes_links'=> 'boolean',
            'copyright'=> 'nullable|string|max:290',
        ];
    }

    public function messages()
    {
        return [
            'portal_nome.string' => 'O nome do portal deve ser um texto.',
            'portal_nome.max' => 'O nome do portal não pode ter mais que 200 caracteres.',

            'olimpo_app_nome.string' => 'O nome do aplicativo deve ser um texto.',
            'olimpo_app_nome.max' => 'O nome do aplicativo não pode ter mais que 200 caracteres.',

            'primary_color.required' => 'A cor primária é obrigatória.',
            'primary_color.string' => 'A cor primária deve ser um texto.',

            'secondary_color.required' => 'A cor secundária é obrigatória.',
            'secondary_color.string' => 'A cor secundária deve ser um texto.',

            'shortcut_icon.image' => 'O ícone deve ser uma imagem válida.',
            'shortcut_icon.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'shortcut_icon.max' => 'A imagem não pode ter mais de 2MB.',

            'mostrar_redes_links.boolean' => 'O campo para mostrar os links das redes deve ser verdadeiro ou falso.',

            'copyright.string' => 'O texto de copyright deve ser um texto.',
            'copyright.max' => 'O texto de copyright não pode ter mais que 250 caracteres.',
        ];
    }
}
