<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\Sobre;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class SobreController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $dado = Sobre::current();
        $config = AppConfig::current();
        return view('admin.configuracoes.sobre.index', compact('entidadeVisual', 'dado', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        //dd($request);
        if (Gate::allows('isAdmin')) {
            try{
               $sobre = Sobre::current();

                $sobre->update([
                    'conteudo' => $request->input('conteudo'),
                    'estado'   => $request->input('estado'),
                ]);

                return redirect()->back()->with('success', 'Seção Sobre atualizada com sucesso.');
        

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao actualizar a secção Sobre!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Sobre $sobre)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Sobre $sobre)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Sobre $sobre)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Sobre $sobre)
    {
        //
    }
}
