<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\SmsLogs;
use Illuminate\Http\Request;

class SmsLogsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $logs = SmsLogs::latest()->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.auditoria.logsSms.index',compact('logs', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $id = decrypt($id);
        $log = SmsLogs::findOrFail($id); // Busca sms pelo ID
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.auditoria.logsSms.show', compact('log', 'entidadeVisual', 'config'));
    }

    /**
     * Display the specified resource.
     */
    public function show(SmsLogs $smsLogs)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SmsLogs $smsLogs)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, SmsLogs $smsLogs)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SmsLogs $smsLogs)
    {
        //
    }
}
