<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\Beneficio;
use App\Models\Bunner;
use App\Models\CategoriaBeneficio;
use App\Models\CategoriaParceiro;
use App\Models\ContactoAdmin;
use App\Models\EntidadeSys;
use App\Models\EstruturaOrganica;
use App\Models\Evento;
use App\Models\Legislacao;
use App\Models\MembroComissao;
use App\Models\MissaoVisao;
use App\Models\Noticia;
use App\Models\Parceiro;
use App\Models\PCA_Mensagem;
use App\Models\PerguntaFrequente;
use App\Models\PR_Mensagem;
use App\Models\Sobre;
use App\Models\Valores;
use Illuminate\Http\Request;

class SiteController extends Controller {

    protected function home () {

        $totalBeneficios = CategoriaBeneficio::where('estado', 1)->count();        
        $totalParceiros = Parceiro::where('estado', 1)->count();        
        $noticiasRecentes = Noticia::where('estado', 1)->latest()->limit(3)->get();
        $eventosRecentes = Evento::where('estado', 1)->latest()->limit(3)->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItems = Bunner::where('estado', 1)->get();
        return view('welcome', compact('noticiasRecentes', 'eventosRecentes', 'totalBeneficios', 'bunnerItems', 'totalParceiros', 'entidadeVisual_header', 'entidadeVisual_footer', 'config'));

    }

    protected function perguntasFrequentes () {

        $perguntas = PerguntaFrequente::where('estado', 1)->latest()->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.perguntasFrequentes', compact('perguntas', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem', 'bunnerItem'));

    }

    protected function contactos () {

        $contacto = ContactoAdmin::where('estado', 1)->first();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.contactos', compact('contacto', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function mensagemPresidente () {

        $mensagem = PR_Mensagem::where('estado', 1)->first();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        //dd($mensagem);
        return view('olimpoPortal.mensagemPresidente', compact('mensagem', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));
    }

    protected function mensagemPCA () {

        $mensagem = PCA_Mensagem::where('estado', 1)->first();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        //dd($mensagem);
        return view('olimpoPortal.mensagemPca', compact('mensagem', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));
    }

    protected function apresentacao () {
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $entidadeVisual_marca = EntidadeSys::getLogoByLocal(7);
        $config = AppConfig::current();
        $sobre = Sobre::where('estado', 1)->first();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        $bunnerItems = Bunner::where('estado', 1)->limit(3)->get();
        $positions = [
            ['top' => '20%', 'left' => '-27%'],
            ['top' => '-48%', 'left' => '-17%'],
            // ['top' => '20%', 'left' => '20%'],
            ['top' => '0', 'left' => '0'],
            // ['top' => '80%', 'left' => '-10%'],
        ];

        return view('olimpoPortal.apresentacao', compact('sobre', 'positions', 'entidadeVisual_header', 'entidadeVisual_footer', 'entidadeVisual_marca', 'config', 'bunnerItem', 'bunnerItems'));
    }

    protected function estruturaOrganica () {

        $estrutura = EstruturaOrganica::where('estado', 1)->first();
        $membros = MembroComissao::where('estado', 1)->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        //dd($membros[0]->cargos->nome);
        return view('olimpoPortal.estruturaOrganica', compact('estrutura', 'membros', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));
    }

    protected function missaoValor () {

        $metas = MissaoVisao::where('estado', 1)->latest()->get();
        $valores = Valores::where('estado', 1)->latest()->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.missaoValor', compact('metas', 'valores', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function noticias () {

        $noticias = Noticia::where('estado', 1)->latest()->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        
        return view('olimpoPortal.noticias', compact('noticias', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }


 
    protected function noticiasDetalhe ($id) {

        $ID = decrypt($id);
        $noticia = Noticia::findOrFail($ID);
        $noticiasDestaques = Noticia::where('destaque', 1)
                                    ->where('id', '!=', $ID)
                                    ->latest()
                                    ->limit(5)
                                    ->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.detalhe_noticia', compact('noticia', 'noticiasDestaques', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function eventos () {

        $eventos = Evento::where('estado', 1)->latest()->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        
        return view('olimpoPortal.eventos', compact('eventos', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function eventosDetalhe($id) {

        $ID = decrypt($id);
        $evento = Evento::findOrFail($ID);
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.detalhe_eventos', compact('evento', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function beneficios () {

        $categorias = CategoriaBeneficio::where('estado', 1)
                                        ->whereHas('beneficios', function ($query) {
                                            $query->where('estado', 1);
                                        })
                                        ->with(['beneficios' => function ($query) {
                                            $query->where('estado', 1);
                                        }])
                                        ->get();

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();

        return view('olimpoPortal.beneficios', compact('categorias', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function calendarioEventos () {
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();

        return view('olimpoPortal.calendarioEventos', compact('entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function empresasParceiras () {

        // Obter todas as categorias com os parceiros associados
        $categorias = CategoriaParceiro::where('estado', 1)
                                        ->whereHas('parceiros', function ($query) {
                                            $query->where('estado', 1);
                                        })
                                        ->with(['parceiros' => function ($query) {
                                            $query->where('estado', 1);
                                        }])
                                        ->latest()
                                        ->get();

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        //dd($parceiros);
        
        return view('olimpoPortal.empresasParceiras', compact('categorias', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));


    }


    protected function legislacao () {

        $legislacoes = Legislacao::where('estado', 1)->latest()->get();
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();
        return view('olimpoPortal.legislacao',compact('legislacoes', 'entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }

    protected function relatorios () {

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(4);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(5);
        $config = AppConfig::current();
        $bunnerItem = Bunner::where('estado', 1)->where('isFixo', 1)->first();

        return view('olimpoPortal.relatorios', compact('entidadeVisual_header', 'entidadeVisual_footer', 'config', 'bunnerItem'));

    }



    // protected function authLogin (Request $request) {

    //     $dadosUtilizador = $request->only('email','password');
    //     $estado = User::getEstado($request['email']);
    //     try {
    //         if (!empty($estado)) {
    //             if(Auth::attempt($dadosUtilizador) && ($estado[0]->estado == 1)){
    //                 $request->session()->regenerate();
    //                 $retorno['estado'] = true;
    //                 return response($retorno);

    //             }else {
    //                 $retorno['estado'] = false;
    //                 $retorno['erro'] = 'Email ou Senha errados';
    //                 return response($retorno);

    //             }
    //         }else {
    //             $retorno['estado'] = false;
    //             $retorno['erro'] = 'Email ou Senha errados';
    //             return response($retorno);

    //         }

    //     } catch (\Throwable $th) {

    //         return response([$th->getMessage(), "errrrooooo!!!"]);

    //     }
    //     $retorno['estado'] = false;

    //     $retorno['erro'] = 'Email ou Senha errados';

    //     return response($retorno);

    // }



}
