<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\EntidadeSys;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use App\Models\Orgao;
use App\Models\Profissao;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class PainelController extends Controller
{
    //
    public function index(){
        $orgaos = Orgao::all();
        $profissoes = Profissao::all();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.painel.painel', compact('orgaos', 'profissoes', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function updateProfissoes(){
        if(Gate::allows('isAdmin') || Gate::allows('isGestor')){
            try {
                //code...
                $response = Http::get(config('services.api_n2bs.get_profissoes'));
                $totalActualizado = 0;
                $mensagem = "Não foi registada nenhuma profissão nova.";
                // dd($response);
                if($response->successful()){
                    $profissoes = json_decode($response->body());
                    // dd($profissoes);
                    if(count($profissoes)==0){
                        return redirect()->back()->withErrors('De momento, não há profissões registadas.');
                    }
                    try {
                        //code...
                        DB::beginTransaction();
                        // dd($profissoes);
                        foreach ($profissoes as $item) {
                            if(!Profissao::where('nome',$item->nome)->exists()){
                                $profissao = new Profissao();
                                $profissao->nome = $item->nome;
                                $profissao->descricao = $item->descricao;
                                $profissao->isencao = $item->isencao;
                                $profissao->save();

                                $totalActualizado = $totalActualizado + 1;
                            }
                        }
                        DB::commit();
                        // dd($totalActualizado, Profissao::all());
                    } catch (\Throwable $th) {
                        //throw $th;
                        DB::rollBack();
                        $totalActualizado = 0;
                    }
                    // dd($totalActualizado);
                    if($totalActualizado!=0){
                        $mensagem = "Foram actualizada(s) $totalActualizado profissão(s).";
                    }
                }else{
                    return redirect()->back()->with('success', "Actualização sem sucesso.");
                }
                // dd(json_decode($response->body()), count(json_decode($response->body())));
                return redirect()->back()->with('success', $mensagem);
            } catch (\Throwable $th) {
                //throw $th;
                return redirect()->back()->withErrors('Erro de conexão: '.$th->getMessage());
            }
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }
    }

    public function updateOrgaos(){
        if(Gate::allows('isAdmin') || Gate::allows('isGestor')){
            try {
                //code...

                $response = http::get(config('services.api_n2bs.get_orgaos'));


                //dd($response->body());
                $totalActualizado = 0;
                $mensagem = "Não foi actualizado nenhum órgão.";
                if($response->successful()){
                    $orgaos = json_decode($response->body());
                    //dd($orgaos);
                    if(count($orgaos)==0){
                        return redirect()->back()->withErrors('De momento, não há órgãos registados.');
                    }
                    try {

                        //code...
                        DB::beginTransaction();
                        foreach ($orgaos as $item) {
                            //dd(Orgao::where('nome',$item->nome)->exists());
                            if(!Orgao::where('nome',$item->nome)->exists()){
                                $orgao = new Orgao();
                                $orgao->nome = $item->nome;
                                $orgao->descricao = $item->descricao;
                                $orgao->seAplica = $item->seAplica;
                                $orgao->save();

                                $totalActualizado = $totalActualizado + 1;
                            }
                        }
                        DB::commit();
                        // dd($totalActualizado, Profissao::all());
                    } catch (\Throwable $th) {
                        //throw $th;
                        DB::rollBack();
                        $totalActualizado = 0;
                    }
                    // dd($totalActualizado);
                    if($totalActualizado!=0){
                        $mensagem = "Foram actualizado(s) $totalActualizado órgão(s).";
                    }
                }else{
                    return redirect()->back()->with('success', "Actualização sem sucesso.");
                }
                // dd(json_decode($response->body()), count(json_decode($response->body())));
                return redirect()->back()->with('success', $mensagem);
            } catch (\Throwable $th) {
                //throw $th;
                return redirect()->back()->withErrors('Erro de conexão');
            }
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }
    }
}
