<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMensagemPcaRequest;
use App\Http\Requests\UpdateMensagemPcaRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\MembroComissao;
use App\Models\PCA_Mensagem;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class PCAMensagemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $mensagens = PCA_Mensagem::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPCA.index', compact('mensagens', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // //
        // $prs = MembroComissao::where('estado', 1)
        //                     ->whereHas('cargos', function ($query) {
        //                         $query->where('principal', 1);
        //                     })
        //                     ->get();

        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPCA.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMensagemPcaRequest $request)
    {
        //
        $pathFoto = null;
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $mensagens = PCA_Mensagem::all();
                foreach ($mensagens as $mensagen) {
                    if($mensagen->estado == 1 && $request->estado == 1){
                        return redirect()->back()->withErrors('Já existe um Mensagem do PCA Activa!');
                    }
                }

                if ($request->file('foto') != null) {
                    $foto = $request->file('foto');
                    $pathFoto = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/imagens/membrosComissao"), $pathFoto);
                }

                $mensagem = new PCA_Mensagem();
                $mensagem->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $mensagem->mensagem = $request->input('mensagem');
                $mensagem->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $mensagem->foto = $pathFoto;
                $mensagem->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $mensagem->save();

                DB::commit();

                return redirect()->route('mensagem-pca.index')->with('success', 'Mensagem do PCA registrada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar Mensagem do PCA!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $mensagem = PCA_Mensagem::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPCA.show', compact('mensagem', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $mensagem = PCA_Mensagem::findOrFail($ID);
        // $prs = MembroComissao::where('estado', 1)
        //                     ->whereHas('cargos', function ($query) {
        //                         $query->where('principal', 1);
        //                     })
        //                     ->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPCA.edit', compact('mensagem', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMensagemPcaRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $sms = PCA_Mensagem::findOrFail($ID);
                $pathFoto = $sms->imagem;

                if ($request->file('foto') != null) {
                    if ($pathFoto && file_exists(public_path("admin/imagens/membrosComissao/{$pathFoto}"))) {
                        unlink(public_path("admin/imagens/membrosComissao/{$pathFoto}"));
                    }

                    $foto = $request->file('foto');
                    $pathFoto = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/imagens/membrosComissao"), $pathFoto);
                }

                $mensagens = PCA_Mensagem::all();
                foreach ($mensagens as $mensagen) {
                    if($mensagen->estado == 1 && $request->estado == 1){
                        if(!($mensagen->id == $ID)){
                            return redirect()->back()->withErrors('Já existe um Mensagem do Presidente Activa!');
                        }
                    }
                }
                
                $mensagem = PCA_Mensagem::findOrFail($ID);

                $mensagem->mensagem = $request->input('mensagem');
                $mensagem->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $mensagem->mensagem = $request->input('mensagem');
                $mensagem->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $mensagem->foto = $pathFoto;
                $mensagem->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $mensagem->save();

                DB::commit();

                return redirect()->route('mensagem-pca.index')->with('success', 'Mensagem do PCA atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                //DD($error);
                return redirect()->back()->withErrors('Falha ao atualizar a Mensagem do PCA!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $mensagem = PCA_Mensagem::findOrFail($ID);

                $mensagem->delete();
                DB::commit();

                return redirect()->route('mensagem-pca.index')->with('success', 'Mensagem do PCA excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Mensagem do PCA!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
