<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\NotificacaoConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class NotificacaoConfigController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $config = AppConfig::current();
        $notificacao = NotificacaoConfig::current();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.configuracoes.entidade.appNotification.create', compact('config', 'notificacao', 'entidadeVisual'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        if (Gate::allows('isAdmin')) {

            $config = NotificacaoConfig::current();

            $data = $request->only([
                'tipo',
                'descricao',
            ]);

            // dd($data['tipo']);

            $tipos = [
                "1" => "Mensagens",
                "2" => "Emails",
                // "3" => "Emails & Mensagens",
            ];

            $config->update($data);

            // return redirect()->route('associados.index')
            //                 ->with('success','Associado criado com successo.');

            return redirect()->back()->with('success', 'Forma de notificação actualizada com sucesso, apartir de agora o Sistema vai utilizar o serviço de '.$tipos[$data['tipo']].' para as Notificações.');
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(NotificacaoConfig $notificacaoConfig)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NotificacaoConfig $notificacaoConfig)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, NotificacaoConfig $notificacaoConfig)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NotificacaoConfig $notificacaoConfig)
    {
        //
    }
}
