<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMissaoVisaoRequest;
use App\Http\Requests\UpdateMissaoVisaoRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\MissaoVisao;
use Exception;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class MissaoVisaoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $metas = MissaoVisao::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.missaoVisao.index', compact('metas', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.missaoVisao.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMissaoVisaoRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{          
                DB::beginTransaction();

                $metas = MissaoVisao::all();
                foreach ($metas as $meta) {
                    if($meta->categoria == $request->categoria && $meta->estado == 1){
                        if($request->estado == 1 ){
                            if($request->categoria == 1) return redirect()->back()->withErrors('Já existe uma Missão registrada com o estado Activo!');
                            return redirect()->back()->withErrors('Já existe uma Visão registrada com o estado Activo!');
                        }
                    }
                }

                $metas = new MissaoVisao();
                $metas->categoria = filter_var($request->categoria, FILTER_SANITIZE_STRING);
                $metas->descricao = filter_var($request->descricao, FILTER_SANITIZE_STRING);
                $metas->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $metas->save();

                DB::commit();

                return redirect()->route('missao-visao.index')->with('success', 'Missão/Visão registrado com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar a Missão/Visão!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $meta = MissaoVisao::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.missaoVisao.show', compact('meta', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $meta = MissaoVisao::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.missaoVisao.edit', compact('meta', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMissaoVisaoRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();
                $ID = decrypt($id);

                $metas = MissaoVisao::all();
                foreach ($metas as $meta) {
                    if($meta->id != $ID && $meta->categoria == $request->categoria && $meta->estado == 1){
                        if($request->estado == 1 ){
                            if($request->categoria == 1) return redirect()->back()->withErrors('Já existe uma Missão registrada com o estado Activo!');
                            return redirect()->back()->withErrors('Já existe uma Visão registrada com o estado Activo!');
                        }
                    }
                }

                
                $valor = MissaoVisao::findOrFail($ID);
                
                $valor->categoria = filter_var($request->categoria, FILTER_SANITIZE_STRING);
                $valor->descricao = filter_var($request->descricao, FILTER_SANITIZE_STRING);
                $valor->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $valor->save();

                DB::commit();

                return redirect()->route('missao-visao.index')->with('success', 'Missão/Visão atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar o Valor!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $metas = MissaoVisao::findOrFail($ID);

                $metas->delete();
                DB::commit();

                return redirect()->route('missao-visao.index')->with('success', 'Missão/Visão excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Missão/Visão!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
