<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMembroComissaoRequest;
use App\Http\Requests\UpdateMembroComissaoRequest;
use App\Models\AppConfig;
use App\Models\Cargo;
use App\Models\EntidadeSys;
use App\Models\MembroComissao;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class MembroComissaoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $membros = MembroComissao::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.membroComissao.index', compact('membros', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $cargos = Cargo::where('estado', 1)->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.membroComissao.create', compact('cargos', 'entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMembroComissaoRequest $request)
    {
        //
        $pathFoto = null;
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();                

                $membros = MembroComissao::all();
                foreach ($membros as $membro) {
                    if($membro->cargos->principal == 1 && $membro->cargo_id == $request->cargo && $membro->estado == 1){
                        if($request->estado == 1 ){
                            return redirect()->back()->withErrors('Já existe um membro Activo com este Cargo!');
                        }
                    }
                }

                if ($request->file('foto') != null) {
                    $foto = $request->file('foto');
                    $pathFoto = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/imagens/membrosComissao"), $pathFoto);
                }

                $membro = new MembroComissao();
                $membro->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $membro->biografia = filter_var($request->biografia, FILTER_SANITIZE_STRING);
                $membro->cargo_id = filter_var($request->cargo, FILTER_SANITIZE_STRING);
                $membro->foto         = $pathFoto;
                $membro->estado         = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $membro->save();

                DB::commit();

                return redirect()->route('membros-comissao.index')->with('success', 'Membro da Comissão registrado com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar Membro da Comissão!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $membro = MembroComissao::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.membroComissao.show', compact('membro', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $membro = MembroComissao::findOrFail($ID);
        $cargos = Cargo::where('estado', 1)->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.membroComissao.edit', compact('membro', 'cargos', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMembroComissaoRequest $request, $id)
    {
        //
         if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $membro = MembroComissao::findOrFail($ID);
                $pathFoto = $membro->foto;

                $membros = MembroComissao::where('estado', 1)->get();
                foreach ($membros as $memb) {
                    if($memb->id != $ID && $memb->cargos->principal == 1 && $memb->cargo_id == $request->cargo && $memb->estado == 1){
                        if($request->estado == 1){
                            return redirect()->back()->withErrors('Já existe um membro Activo com este Cargo!');
                        }
                    }
                }

                if ($request->file('foto') != null) {
                    if ($pathFoto && file_exists(public_path("admin/imagens/membrosComissao/{$pathFoto}"))) {
                        unlink(public_path("admin/imagens/membrosComissao/{$pathFoto}"));
                    }

                    $foto = $request->file('foto');
                    $pathFoto = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/imagens/membrosComissao"), $pathFoto);
                }

                $membro->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $membro->biografia = filter_var($request->biografia, FILTER_SANITIZE_STRING);
                $membro->cargo_id = filter_var($request->cargo, FILTER_SANITIZE_STRING);
                $membro->foto         = $pathFoto;
                $membro->estado         = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $membro->save();

                DB::commit();

                return redirect()->route('membros-comissao.index')->with('success', 'Membro da Comissão atualizado com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar o Membro da Comissão!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $membro = MembroComissao::findOrFail($ID);

                if ($membro->foto && file_exists(public_path("admin/imagens/membrosComissao/{$membro->foto}"))) {
                    unlink(public_path("admin/imagens/membrosComissao/{$membro->foto}"));
                }

                $membro->delete();
                DB::commit();

                return redirect()->route('membros-comissao.index')->with('success', 'Membro da Comissão excluído com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír o Membro da Comissão!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
