<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\EntidadeSys;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    //
    protected function homeAdmin () {
        if(Auth::check() && Auth::user()->role_id == 1){
            $entidadeVisual = EntidadeSys::getLogoByLocal(11);
            $config = AppConfig::current();
            return view('admin.home.admin', compact("entidadeVisual", 'config'));

        }
        return redirect("login")->withSuccess('Sem permissões de acesso');
    }

    protected function homeGestor () {
        if(Auth::check() && Auth::user()->role_id == 2){
            $entidadeVisual = EntidadeSys::getLogoByLocal(11);
            $config = AppConfig::current();
            return view('admin.home.gestor', compact("entidadeVisual", 'config'));
        }
        return redirect("login")->withSuccess('Sem permissões de acesso');
    }

    protected function homeEditor () {
        if(Auth::check() && Auth::user()->role_id == 3){
            $entidadeVisual = EntidadeSys::getLogoByLocal(11);
            $config = AppConfig::current();
            return view('admin.home.editor', compact("entidadeVisual", 'config'));

        }
        return redirect("login")->withSuccess('Sem permissões de acesso');
    }
}
