<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreDadosContactosRequest;
use App\Http\Requests\UpdateDadosContactosRequest;
use App\Models\AppConfig;
use App\Models\ContactoAdmin;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class ContactoAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $contactos = ContactoAdmin::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.contacto.index', compact('contactos', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.contacto.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDadosContactosRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $contactos = ContactoAdmin::all();
                foreach ($contactos as $contacto) {
                    if($contacto->estado == 1 && $request->estado == 1){
                        return redirect()->back()->withErrors('Já existe Dados de Contacto registrado com o estado Activo!');
                    }
                }

                $contacto = new ContactoAdmin();
                $contacto->endereco = filter_var($request->endereco, FILTER_SANITIZE_STRING);
                $contacto->emailGeral = filter_var($request->emailGeral, FILTER_SANITIZE_STRING);
                $contacto->emailSuporte  = filter_var($request->emailSuporte, FILTER_SANITIZE_STRING);
                $contacto->telefone  = filter_var($request->telefone, FILTER_SANITIZE_STRING);
                $contacto->latitude   = filter_var($request->latitude, FILTER_SANITIZE_STRING);
                $contacto->longitude   = filter_var($request->longitude, FILTER_SANITIZE_STRING);
                $contacto->estado   = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $contacto->save();

                DB::commit();

                return redirect()->route('contactos-portal.index')->with('success', 'Dados de Contacto registrados com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar os Dados de Contacto!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $contacto = ContactoAdmin::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.contacto.show', compact('contacto', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $contacto = ContactoAdmin::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(10);
        $config = AppConfig::current();

        return view('admin.configuracoes.contacto.edit', compact('contacto', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDadosContactosRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $contacto = ContactoAdmin::findOrFail($ID);

                $contactos = ContactoAdmin::all();
                foreach ($contactos as $contacto) {
                    if($contacto->id != $ID && $contacto->estado == 1){
                        if($request->estado == 1){
                            return redirect()->back()->withErrors('Já existe Dados de Contacto registrado com o estado Activo!');
                        }
                    }
                }

                $contacto->endereco = filter_var($request->endereco, FILTER_SANITIZE_STRING);
                $contacto->emailGeral  = filter_var($request->emailGeral, FILTER_SANITIZE_STRING);
                $contacto->emailSuporte  = filter_var($request->emailSuporte, FILTER_SANITIZE_STRING);
                $contacto->telefone  = filter_var($request->telefone, FILTER_SANITIZE_STRING);
                $contacto->latitude   = filter_var($request->latitude, FILTER_SANITIZE_STRING);
                $contacto->longitude   = filter_var($request->longitude, FILTER_SANITIZE_STRING);
                $contacto->estado   = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $contacto->save();

                DB::commit();

                return redirect()->route('contactos-portal.index')->with('success', 'Dados de Contacto atualizado com sucesso!');
            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar os Dados de Contacto!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $contacto = ContactoAdmin::findOrFail($ID);
                $contacto->delete();
                DB::commit();

                return redirect()->route('contactos-portal.index')->with('success', 'Dados de Contacto excluído com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír os Dados de Contacto!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
