<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\Carrossel;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class CarrosselController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $dados = Carrossel::all();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.entidade.carrosselBoasVindas.index', compact('dados', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.entidade.carrosselBoasVindas.create', compact('entidadeVisual','config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $pathLogo = null;
        if (Gate::allows('isAdmin')) {
            try{
                DB::beginTransaction();

                if ($request->file('imagem') != null) {
                    $foto = $request->file('imagem');
                    $pathLogo = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/endidadesIMG/bunnerSlide/carrossel"), $pathLogo);
                }

                $item = new Carrossel();
                $item->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $item->imagem = $pathLogo;
                $item->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $item->save();

                DB::commit();

                return redirect()->route('carrossel.index')->with('success', 'Imagem do Carressel adicionado com sucesso.');

            }catch(Exception $error){
                DB::rollBack();
                dd($error);
                return redirect()->back()->withErrors('Falha ao registrar a Imagem do Carressel!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $dado = Carrossel::findOrFail($ID); 
        $config = AppConfig::current();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.configuracoes.entidade.carrosselBoasVindas.show', compact('dado', 'config', 'entidadeVisual'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $dado = Carrossel::findOrFail($ID); 
        $config = AppConfig::current();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.configuracoes.entidade.carrosselBoasVindas.edit', compact('dado', 'config', 'entidadeVisual'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        if (Gate::allows('isAdmin')) {
            try{
                DB::beginTransaction();

                $ID = decrypt($id);
                $item = Carrossel::findOrFail($ID); 
                $pathImagem = $item->imagem;

                if ($request->file('imagem') != null) {
                    if ($pathImagem && file_exists(public_path("admin/endidadesIMG/bunnerSlide/carrossel/{$pathImagem}"))) {
                        unlink(public_path("admin/endidadesIMG/bunnerSlide/carrossel/{$pathImagem}"));
                    }

                    $foto = $request->file('imagem');
                    $pathImagem = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/endidadesIMG/bunnerSlide/carrossel"), $pathImagem);
                }

                $item->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $item->imagem = $pathImagem;
                $item->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $item->save();

                DB::commit();
                return redirect()->route('carrossel.index')->with('success', 'A imagem do Carrossel foi actualizada com sucesso.');
            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao actualizar a imagem do carrossel!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $item = Carrossel::findOrFail($ID);

                if ($item->imagem && file_exists(public_path("admin/endidadesIMG/bunnerSlide/carrossel/{$item->imagem}"))) {
                    unlink(public_path("admin/endidadesIMG/bunnerSlide/carrossel/{$item->imagem}"));
                }

                $item->delete();
                DB::commit();

                 return redirect()->route('carrossel.index')->with('success', 'Imagem do Carrossel excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a imagem do carrossel!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
