<?php

namespace App\Http\Controllers;

use App\Data\EmailLogData;
use App\General\DataGeneral;
use Illuminate\Http\Request;
use App\Models\Orgao;
use App\Models\Profissao;
use App\Models\Candidato;
use App\Http\Requests\CandidaturaRequest;
use Illuminate\Support\Facades\Mail;
use App\Mail\CandidaturaPendente;
use App\Models\AppConfig;
use App\Models\Carrossel;
use App\Models\EntidadeSys;
use App\Models\NotificacaoConfig;
use App\Models\Sms;
use App\Services\EmailLogs;
use App\Services\TelcoSmsService;
use Exception;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Laravel\Facades\Image; 


class CandidatoController extends Controller
{

    protected TelcoSmsService $smsTelcoService;

    public function __construct(TelcoSmsService $smsTelcoService)
    {
        $this->smsTelcoService = $smsTelcoService;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $orgaos = Orgao::all();
        $profissao = Profissao::all();

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(8);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(9);
        $entidadeBackground = EntidadeSys::getLogoByLocal(10);
        $carrossel = Carrossel::where('estado', 1)->get(); 
        $config = AppConfig::current();
        return View('cadastro.create', compact('carrossel', 'orgaos', 'profissao', 'entidadeVisual_header', 'entidadeBackground', 'entidadeVisual_footer', 'config'));
    }

     public function index2()
    {
        $candidatos = Candidato::all();

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(8);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(9);
        $config = AppConfig::current();
        return View('admin.candidato.index', compact('candidatos', 'entidadeVisual_header', 'entidadeVisual_footer', 'config'));
    }

    public function boasVindas(){

        $entidadeVisual_header = EntidadeSys::getLogoByLocal(8);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(9);
        $entidadeBackground = EntidadeSys::getLogoByLocal(10);
        $carrossel = Carrossel::where('estado', 1)->get(); 
        $config = AppConfig::current();
        return View('cadastro.boasvindas', compact('carrossel', 'entidadeVisual_header', 'entidadeBackground', 'entidadeVisual_footer', 'config'));
    }



    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    // public function store(CandidaturaRequest $request)
    // {

    //     //dd($request);
    //     DB::beginTransaction();
    //     try {

    //         $nomeIdentificacao = null;
    //         // $nomeDeclaracao = null;

    //         // if ($request->file('arquivo_identificacao') != null && $request->file('arquivo_declaracao') != null) {
    //         if ($request->file('arquivo_identificacao') != null) {
    //             $anexo1 = $request->file('arquivo_identificacao');
    //             // $anexo2 = $request->file('arquivo_declaracao');

    //             $pathDestino = public_path("/docs/cadastro");

    //             // Renomeia e move o arquivo de identificação
    //             $nomeIdentificacao = $request->n_identificacao . '_identificacao.pdf';
    //             $anexo1->move($pathDestino, $nomeIdentificacao);

    //             // Renomeia e move o arquivo de declaração
    //             // $nomeDeclaracao = $request->n_identificacao . '_declaracao.pdf';
    //             // $anexo2->move($pathDestino, $nomeDeclaracao);
    //         }

    //         // Criação do cadastro
    //         $novo = new Candidato();
    //         $novo->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
    //         $novo->n_identificacao = filter_var($request->n_identificacao, FILTER_SANITIZE_STRING);
    //         $novo->tipo_documento = filter_var($request->tipo_documento, FILTER_SANITIZE_STRING);
    //         $novo->email = filter_var(strtolower($request->email), FILTER_SANITIZE_EMAIL);
    //         $novo->telefone = filter_var($request->telefone, FILTER_SANITIZE_STRING);
    //         $novo->n_mecanografico = filter_var($request->n_mecanografico, FILTER_SANITIZE_STRING);
    //         $novo->orgao_id = filter_var($request->orgao_id, FILTER_SANITIZE_NUMBER_INT);
    //         $novo->id_profissao = filter_var($request->profissao_id, FILTER_SANITIZE_NUMBER_INT);
    //         $salarioSemFormatacao = DataGeneral::retirarFormatacaoSalario($request->salario);
    //         $novo->salario = number_format($salarioSemFormatacao,2,".","");
    //         $novo->arquivo_identificacao = $nomeIdentificacao;
    //         // $novo->arquivo_declaracao = $nomeDeclaracao;
    //         $novo->save();
    //         DB::commit();

    //         $entidadeEmail = EntidadeSys::getLogoByLocal(1); 
    //         $dados = [
    //             'nomeCandidato' => $novo->nome,
    //             'nomeEntidade' => $entidade->nome ?? 'SISTEMA - OlimpoWeb',
    //             'assunto' => 'Candidatura ao ' . ($entidadeEmail ?? 'SISTEMA - OlimpoWeb'),
    //         ];

    //         try {
                 
    //             Mail::to($novo->email)->send(new CandidaturaPendente($dados));

    //             $logData = [
    //                 'email_receptor' => $novo->email,
    //                 'email_emissor' => config('mail.from.address'),
    //                 'assunto' => 'Candidatura ao FSTPL',
    //                 'body' =>  json_encode($dados, JSON_UNESCAPED_UNICODE),
    //                 'mail_class' => CandidaturaPendente::class,
    //                 'mensagem_erro' => '',
    //                 'prioridade' => 3,
    //                 'estado' => 1,
    //             ];
    
    //             EmailLogs::log(new EmailLogData($logData));
    //         } catch (\Throwable $th) {
    //             $logData = [
    //                 'email_receptor' => $novo->email,
    //                 'email_emissor' => config('mail.from.address'),
    //                 'assunto' => 'Candidatura ao ',
    //                 'body' =>  json_encode($dados, JSON_UNESCAPED_UNICODE),
    //                 'mail_class' => CandidaturaPendente::class,
    //                 'mensagem_erro' => $th->getMessage(),
    //                 'prioridade' => 1,
    //                 'estado' => 0,
    //             ];
    
    //             EmailLogs::log(new EmailLogData($logData));
    //         }
    //         return redirect()->route('candidato.create')->with('success', 'O seu pedido de Adesão foi realizado com sucesso, a sua candidatura encontra-se em análise.');
    //     } catch (Exception $th) {
    //         // Rollback no caso de erro
    //         DB::rollBack();

    //         return redirect()->route('candidato.create')->with('error', 'Falha ao efetuar o cadastro. Tente novamente.');
    //     }
    // }

    
    public function store(CandidaturaRequest $request){
        DB::beginTransaction();

        try {
            $nomeIdentificacao = null;   

            if ($request->hasFile('arquivo_identificacao')) {
                $anexo1 = $request->file('arquivo_identificacao');

                $pathDestino = public_path("/docs/cadastro");

                $nomeIdentificacao = $request->n_identificacao . '_identificacao.pdf';
                $anexo1->move($pathDestino, $nomeIdentificacao);
            }

            if ($request->hasFile('foto_frente') && $request->hasFile('foto_verso')) {

                // 1) Carregar e redimensionar (máx. 1000 px largura)
                $frente = Image::read($request->file('foto_frente'))
                            ->scale(width: 1000);

                $verso  = Image::read($request->file('foto_verso'))
                            ->scale(width: 1000);

                // 2) Criar canvas (empilhar verticalmente)
                $width  = max($frente->width(), $verso->width());
                $height = $frente->height() + $verso->height();

                $canvas = Image::create($width, $height)
                            ->fill('fff'); 

                $canvas->place($frente, 'top-left');
                $canvas->place($verso,  'top-left', 0, $frente->height());

                $nomeIdentificacao = $request->n_identificacao . '_identificacao.jpg';
                $destino = public_path('docs/cadastro/' . $nomeIdentificacao);

                $canvas
                    ->toJpeg(quality: 90)
                    ->save($destino);   
            }

            $novo = new Candidato();
            $novo->nome            = filter_var($request->nome, FILTER_SANITIZE_STRING);
            $novo->n_identificacao = filter_var($request->n_identificacao, FILTER_SANITIZE_STRING);
            $novo->tipo_documento  = filter_var($request->tipo_documento, FILTER_SANITIZE_STRING);

            $novo->email           = $request->filled('email') ? filter_var(strtolower($request->email), FILTER_SANITIZE_EMAIL) : null;

            $novo->telefone        = filter_var($request->telefone, FILTER_SANITIZE_STRING);
            // $novo->n_mecanografico = $request->filled('n_mecanografico') ? filter_var($request->n_mecanografico, FILTER_SANITIZE_STRING) : null;
            $novo->orgao_id        = filter_var($request->orgao_id, FILTER_SANITIZE_NUMBER_INT);
            $novo->id_profissao    = filter_var($request->profissao_id, FILTER_SANITIZE_NUMBER_INT);

            $salarioSemFormatacao = $request->filled('salario') ? DataGeneral::retirarFormatacaoSalario($request->salario) : 0;
            $novo->salario         = number_format($salarioSemFormatacao, 2, '.', '');

            // ficheiro mesclado
            $novo->arquivo_identificacao = $nomeIdentificacao;

            $novo->save();
            DB::commit();

            $entidadeEmail = EntidadeSys::getLogoByLocal(1); 
            $notify = NotificacaoConfig::current();

            if (in_array($notify->tipo, [1, 3])) {
                $data = [
                    'nome' => $novo->nome_completo,
                    'nomeEntidade' => $entidadeEmail->nome ?? 'SISTEMA - OlimpoWeb',
                    'username' => $novo->username,
                ];

                $telefone = $novo->telefone;
                $sms = Sms::gerarMensagemNovoCandidato($data);

                $this->smsTelcoService->enviarMensagem($telefone, $sms);  
            }
            
            if (in_array($notify->tipo, [2, 3])) {
                $dados = [
                    'nomeCandidato' => $novo->nome,
                    'nomeEntidade' => $entidadeEmail->nome ?? 'SISTEMA - OlimpoWeb',
                    'assunto' => 'Candidatura ao ' . ($entidadeEmail->nome ?? 'SISTEMA - OlimpoWeb'),
                ];

                try {
                    
                    Mail::to($novo->email)->send(new CandidaturaPendente($dados));

                    $logData = [
                        'email_receptor' => $novo->email,
                        'email_emissor' => config('mail.from.address'),
                        'assunto' => 'Candidatura ao FSTPL',
                        'body' =>  json_encode($dados, JSON_UNESCAPED_UNICODE),
                        'mail_class' => CandidaturaPendente::class,
                        'mensagem_erro' => '',
                        'prioridade' => 3,
                        'estado' => 1,
                    ];
        
                    EmailLogs::log(new EmailLogData($logData));
                } catch (\Throwable $th) {
                    $logData = [
                        'email_receptor' => $novo->email,
                        'email_emissor' => config('mail.from.address'),
                        'assunto' => 'Candidatura ao FSTPL',
                        'body' =>  json_encode($dados, JSON_UNESCAPED_UNICODE),
                        'mail_class' => CandidaturaPendente::class,
                        'mensagem_erro' => $th->getMessage(),
                        'prioridade' => 1,
                        'estado' => 0,
                    ];
        
                    EmailLogs::log(new EmailLogData($logData));
                }
            }

            return redirect()->route('candidato.create')->with('success', 'O seu pedido de Adesão foi realizado com sucesso, a sua candidatura encontra-se em análise.');

        } catch (Exception $th) {
            DB::rollBack();
            dd($th);
            return redirect()->route('candidato.create')
                ->with('error', 'Falha ao efetuar o cadastro. Tente novamente.');
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    
}
