<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

use App\Models\Pessoa;
use App\Models\Associado;
use App\Models\Documentoidentificacao;
use App\Models\PessoaDocumento;
use App\Models\Endereco;
use App\Models\PessoaEndereco;
use App\Models\Contacto;
use App\Models\PessoaContacto;
use App\Models\BancoContum;

class AssociadoController extends Controller {

    public function getAllAssociados () {
        $dados = [
            $associados = Associado::all(),
        ];

        return view('welcome')->with($dados);
    }

    public function addAssociado (Request $request) {

        $response['estado'] = true;

        $allAssociados = Associado::all();
        foreach ($allAssociados as $associado) {

            if(
                $associado->n_Mecanografico == $request['n_Mecanografico'] || 
                $associado->numero == $request['numero'] || 
                $associado->n_Mecanografico != null
            ){
                $response['errorAlReadyExistsAssociado'] = "Já existe um associado com os mesmos dados individuias!";
                $response['estado'] = false;
                break;
            };

        }

        if($response['estado'] == false) 
            return redirect()->back()->withErrors($response);

        try {

            if ($request->file('foto') != null) {
                $foto = $request->file('foto');
                $pathFoto = $foto->getClientOriginalName();
                $foto->move(public_path("/img/associado"), $pathFoto);
            }else 
                $pathFoto = null;

            DB::beginTransaction();

            // registrando uma pessoa
            $pessoa = new Pessoa();
            $pessoa->nome         = filter_var($request['nome_completo'], FILTER_SANITIZE_STRING);
            $pessoa->genero       = filter_var($request['genero'], FILTER_SANITIZE_STRING);
            $pessoa->estado_civil = filter_var($request['estado_civil'], FILTER_SANITIZE_STRING);
            $pessoa->data_nascimento  = filter_var($request['data_nascimento'], FILTER_SANITIZE_STRING);
            $pessoa->foto         = $pathFoto;
            $pessoa->tipo = 'A';
            $pessoa->save();

            
            $documento = new Documentoidentificacao();
            $documento->TipoDocumento_id = filter_var($request['TipoDocumento_id'], FILTER_SANITIZE_NUMBER_INT);
            $documento->numero = filter_var($request['n_identificacao'], FILTER_SANITIZE_STRING);
            $documento->data_emissao = filter_var($request['data_emissao'], FILTER_SANITIZE_STRING);
            $documento->data_expiracao = filter_var($request['data_expiracao'], FILTER_SANITIZE_STRING);
            $documento->local_emissao = filter_var($request['local_emissao'], FILTER_SANITIZE_STRING);
            $documento->save();

            $pessoaDocumento = new PessoaDocumento();
            $pessoaDocumento->Pessoa = $pessoa->id;
            $pessoaDocumento->DocumentoIdentificacao = $documento->id;
            $pessoaDocumento->save();

            $endereco = new Endereco();
            $endereco->Provincia = filter_var($request['Provincia'], FILTER_SANITIZE_NUMBER_INT);
            $endereco->Municipio = filter_var($request['Municipio'], FILTER_SANITIZE_NUMBER_INT);
            $endereco->bairro = filter_var($request['bairro'], FILTER_SANITIZE_STRING);
            $endereco->rua = filter_var($request['rua'], FILTER_SANITIZE_STRING);
            $endereco->numero = filter_var($request['numero_rua_casa'], FILTER_SANITIZE_STRING);
            $endereco->save();

            $pessoaEndereco = new PessoaEndereco();
            $pessoaEndereco->Pessoa = $pessoa->id;
            $pessoaEndereco->Endereco = $endereco->id;
            $pessoaEndereco->save();

            $contacto = new Contacto();
            $contacto->TipoContacto = filter_var($request['TipoContacto'], FILTER_SANITIZE_NUMBER_INT);
            $contacto->nome = filter_var($request['contacto'], FILTER_SANITIZE_STRING);
            $contacto->save();

            $pessoaContacto = new PessoaContacto();
            $pessoaContacto->Pessoa = $pessoa->id;
            $pessoaContacto->Contacto = $contacto->id;
            $pessoaContacto->save();

            $bancoConta = new BancoContum();
            $bancoConta->Banco_Instituicao = filter_var($request['banco_instituicao'], FILTER_SANITIZE_NUMBER_INT);
            $bancoConta->iban = filter_var($request['iban'], FILTER_SANITIZE_STRING);
            $bancoConta->numero = filter_var($request['numero_conta_banco'], FILTER_SANITIZE_NUMBER_INT);
            $bancoConta->save();

            if ($request->file('anexo') != null) {
                $anexo = $request->file('anexo');
                $pathAnexo = $anexo->getClientOriginalName();
                $anexo->move(public_path("/docs/associado"), $pathAnexo);
            }else 
                $pathAnexo = null;

            $associado = new Associado();
            $associado->pessoa = $pessoa->id;
            $associado->n_Mecanografico = filter_var($request['n_Mecanografico'], FILTER_SANITIZE_NUMBER_INT);
            $associado->Orgao = filter_var($request['orgao'], FILTER_SANITIZE_NUMBER_INT);
            $associado->Cargo = filter_var($request['funcao'], FILTER_SANITIZE_NUMBER_INT);
            $associado->profissao = filter_var($request['categoria'], FILTER_SANITIZE_NUMBER_INT);
            $associado->salario = filter_var($request['salario'], FILTER_SANITIZE_NUMBER_FLOAT);
            $associado->data_admissao = $request['data_admissao'];
            $associado->status = filter_var($request['status'], FILTER_SANITIZE_NUMBER_INT);
            $associado->conta = $bancoConta->id;
            $associado->anexo = $pathAnexo;
            $associado->save();

            DB::commit();

            $response['estado'] = true;

        } catch (Exception $th) {
            DB::rollBack();

            DB::beginTransaction(false);

            $response['error_sql'] = $th->getMessage();
            $response['estado'] = false;

            return redirect()->back()->withErrors($response);
        }

        // $response['erros_validacao_user'] = [];
        // $response['erros_validacao_paciente'] = [];
        // $response['erros_validacao_rcp'] = [];
        
        $response['message'] = "Associado cadastrado com sucesso!!!";
        $response['estado'] = true;

        return response($response);
        // return redirect()->back()->with($response);

    }

}
