<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAppConfigRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class AppConfigController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.entidade.appConfig.index', compact('entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAppConfigRequest $request)
    {
        if (Gate::allows('isAdmin')) {
            
            $config = AppConfig::current();

            $data = $request->only([
                'portal_nome',
                'olimpo_app_nome',
                'primary_color',
                'secondary_color',
                'copyright',
            ]);

            if ($request->hasFile('shortcut_icon') && $request->file('shortcut_icon')->isValid()) {
                $oldfile = $config->shortcut_icon;
                if ($oldfile && file_exists(public_path("/admin/endidadesIMG/app-config/{$oldfile}"))) {
                    unlink(public_path("/admin/endidadesIMG/app-config/{$oldfile}"));
                }
                
                $file = $request->file('shortcut_icon');
                $pathAnexo = $file->getClientOriginalName();
                $file->move(public_path("/admin/endidadesIMG/app-config"), $pathAnexo);
                $data['shortcut_icon'] = $pathAnexo;
            }

            /* ---------- campos JSON ---------- */
            $data['mostrar_redes_links'] = $request->has('mostrar_redes_links');
            $data['menu_items']   = array_values($request->input('menu_conf', []));
            $data['redes_links'] = array_values($request->input('redes_links', []));
            $data['meta_dados'] = [
                'keywords' => $request->input('keywords'),
                'author' => $request->input('author'),
                'description' => $request->input('description'),
            ];

            $config->update($data);
            
            return redirect()->back()->with('success', 'Configurações salvas com sucesso.');
        }else{
            return redirect()->route('admin');
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(AppConfig $appConfig)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AppConfig $appConfig)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, AppConfig $appConfig)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AppConfig $appConfig)
    {
        //
    }
}
