<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

use App\Http\Controllers\Controller;
use App\Models\Candidato;
class CandidatoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $todosCandidatos = Candidato::all();
        return $todosCandidatos;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    function deletarCandidaturas(Request $request) {
        //dd($request->ids);
        try{
            foreach($request->ids as $ids){
                $candidato = Candidato::where('id', '=', $ids)->first();
                // Aqui vai ser eliminado os arquivos do candidato. 
                if (file_exists(public_path('docs/cadastro/'. $candidato->arquivo_identificacao))) {
                    unlink(public_path('docs/cadastro/'. $candidato->arquivo_identificacao));
                }
                if (file_exists(public_path('docs/cadastro/'. $candidato->arquivo_declaracao))) {
                    unlink(public_path('docs/cadastro/'. $candidato->arquivo_declaracao));
                }

                $candidato->delete();
            }
        } catch(\Exception $e){
            return response()->json(['mensagem' => 'erro ao eliminar os candidatos']);
        }
        return response()->json(['mensagem' => 'candidatos eliminados com sucesso']);
    }

    public function downloadAllDocs() {
        $zip = new \ZipArchive();
        $fileName = 'all_docs_associado.zip';

        // Caminho para criar o arquivo zip na pasta 'public'
        $zipPath = public_path($fileName);
        
        // Verifica se conseguiu criar/abrir o ZIP
        if ($zip->open($zipPath, \ZipArchive::CREATE | \ZipArchive::OVERWRITE) === true) {
            $directory = public_path('docs/cadastro/');

            // Verifica se o diretório existe
            if (!is_dir($directory)) {
                return response()->json(['error' => 'Directory not found: ' . $directory], 404);
            }

            // Adiciona todos os arquivos do diretório ao zip
            $files = scandir($directory);
            foreach ($files as $file) {
                $filePath = $directory . $file;
                if (is_file($filePath)) {
                    // Adiciona o arquivo ao zip
                    if (!$zip->addFile($filePath, $file)) {
                        return response()->json(['error' => 'Failed to add file: ' . $file], 500);
                    }
                }
            }

            // Fecha o arquivo ZIP
            $zip->close();
        } else {
            return response()->json(['error' => 'Failed to create zip file'], 500);
        }

        // Retorna o ZIP para download e exclui após o envio
        return response()->download($zipPath)->deleteFileAfterSend(true);
    }
}
