<?php

namespace App\General;
use App\Models\Operacao;
use App\General\DataGeneral;
use Illuminate\Support\Facades\Request;
use App\Models\AuditoriaGeral;

class AuditoriaGeneral {

    public static function log($user, $evento, $modal_id, $model, $dados_antigos, $dados_novos, $descricao){
        AuditoriaGeral::create([
            'user_id' => $user,
            'evento' => $evento,
            'data_registo' => DataGeneral::dataHoraActual(),
            'endereco_ip' => Request::ip(),
            'auditable_id' => $modal_id,
            'auditable_type' => get_class($model),
            'descricao' => $descricao,
            'old_data' => json_encode($dados_antigos),
            'new_data' => json_encode($dados_novos),
        ]);
    }
}
