<?php

namespace App\Data;

use App\General\DataGeneral;

class EmailLogData
{
    public $email_receptor;
    public $email_emissor;
    public $assunto;
    public $body;
    public $mail_class;
    public $mensagem_erro;
    public $estado;
    public $data_tentativa;
    public $tentativas;
    public $prioridade;
    

    public function __construct(array $data)
    {
        $this->email_emissor = $data['email_emissor'] ?? config('mail.from.address');
        $this->email_receptor = $data['email_receptor'] ?? null;
        $this->assunto = $data['assunto'] ?? null;
        $this->body = $data['body'] ?? null;
        $this->mail_class = $data['mail_class'] ?? null;
        $this->mensagem_erro = $data['mensagem_erro'] ?? null;
        $this->estado = $data['estado'] ?? 0; 
        $this->data_tentativa = DataGeneral::dataHoraActual();
        $this->prioridade = $data['prioridade'] ?? 0;	
        $this->tentativas = 1;
    }
}
